/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgprofiles.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ForwarderOrgProfileClientUpdate1.Builder.class)
public final class ForwarderOrgProfileClientUpdate1 {
    private final Optional<String> description;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> phoneNumberPrimary;

    private final Map<String, Object> additionalProperties;

    private ForwarderOrgProfileClientUpdate1(
            Optional<String> description,
            Optional<String> emailAddressPrimary,
            Optional<String> phoneNumberPrimary,
            Map<String, Object> additionalProperties) {
        this.description = description;
        this.emailAddressPrimary = emailAddressPrimary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (description == null) {
            return Optional.empty();
        }
        return description;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("description")
    private Optional<String> _getDescription() {
        return description;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ForwarderOrgProfileClientUpdate1 && equalTo((ForwarderOrgProfileClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ForwarderOrgProfileClientUpdate1 other) {
        return description.equals(other.description)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.description, this.emailAddressPrimary, this.phoneNumberPrimary);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> description = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ForwarderOrgProfileClientUpdate1 other) {
            description(other.getDescription());
            emailAddressPrimary(other.getEmailAddressPrimary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            return this;
        }

        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            if (description.isNull()) {
                this.description = null;
            } else if (description.isEmpty()) {
                this.description = Optional.empty();
            } else {
                this.description = Optional.of(description.get());
            }
            return this;
        }

        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public Builder emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        public Builder emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        public Builder emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public Builder phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        public Builder phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        public Builder phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        public ForwarderOrgProfileClientUpdate1 build() {
            return new ForwarderOrgProfileClientUpdate1(
                    description, emailAddressPrimary, phoneNumberPrimary, additionalProperties);
        }
    }
}
