/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import java.util.concurrent.CompletableFuture;

public class AsyncPaymentsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawPaymentsClient rawClient;

    public AsyncPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan. | (CreateCheckoutSessionReq) -&gt; (CreateCheckoutSessionRes)
     */
    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan. | (CreateCheckoutSessionReq) -&gt; (CreateCheckoutSessionRes)
     */
    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(
            CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().thenApply(response -> response.body());
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).thenApply(response -> response.body());
    }
}
