/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.types.CreateCheckoutSessionRes;

public class PaymentsClient {
    protected final ClientOptions clientOptions;

    private final RawPaymentsClient rawClient;

    public PaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan. | (CreateCheckoutSessionReq) -&gt; (CreateCheckoutSessionRes)
     */
    public CreateCheckoutSessionRes createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).body();
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan. | (CreateCheckoutSessionReq) -&gt; (CreateCheckoutSessionRes)
     */
    public CreateCheckoutSessionRes createCheckoutSessionV1(
            CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).body();
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user. | () -&gt; (bool)
     */
    public boolean syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().body();
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user. | () -&gt; (bool)
     */
    public boolean syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).body();
    }
}
