/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.root;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawRootClient {
    protected final ClientOptions clientOptions;

    public AsyncRawRootClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Test endpoint for authenticated requests that requires valid authentication tokens. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, String>>> pingAuthd() {
        return pingAuthd(null);
    }

    /**
     * Test endpoint for authenticated requests that requires valid authentication tokens. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, String>>> pingAuthd(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("authd")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Map<String, String>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<Map<String, String>>() {}),
                                response));
                        return;
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Test endpoint for optionally authenticated requests that works with or without authentication. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> pingOptionallyAuthd() {
        return pingOptionallyAuthd(null);
    }

    /**
     * Test endpoint for optionally authenticated requests that works with or without authentication. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> pingOptionallyAuthd(
            RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("optionally_authd")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<Map<String, Object>>() {}),
                                response));
                        return;
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Returns a greeting message to verify the API is accessible. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> pingUnauthd() {
        return pingUnauthd(null);
    }

    /**
     * Returns a greeting message to verify the API is accessible. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> pingUnauthd(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<Map<String, Object>>() {}),
                                response));
                        return;
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Returns a health status message used for monitoring system availability and uptime. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> health() {
        return health(null);
    }

    /**
     * Returns a health status message used for monitoring system availability and uptime. | () -&gt; (dict)
     */
    public CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> health(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("health")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Map<String, Object>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<Map<String, Object>>() {}),
                                response));
                        return;
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Test endpoint that intentionally fails for error handling validation and monitoring purposes. | () -&gt; (None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Object>> failure() {
        return failure(null);
    }

    /**
     * Test endpoint that intentionally fails for error handling validation and monitoring purposes. | () -&gt; (None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Object>> failure(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("failure")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Object>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                        return;
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
