/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.root;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncRootClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawRootClient rawClient;

    public AsyncRootClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRootClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawRootClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Test endpoint for authenticated requests that requires valid authentication tokens. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<Map<String, String>> pingAuthd() {
        return this.rawClient.pingAuthd().thenApply(response -> response.body());
    }

    /**
     * Test endpoint for authenticated requests that requires valid authentication tokens. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<Map<String, String>> pingAuthd(RequestOptions requestOptions) {
        return this.rawClient.pingAuthd(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Test endpoint for optionally authenticated requests that works with or without authentication. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> pingOptionallyAuthd() {
        return this.rawClient.pingOptionallyAuthd().thenApply(response -> response.body());
    }

    /**
     * Test endpoint for optionally authenticated requests that works with or without authentication. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> pingOptionallyAuthd(RequestOptions requestOptions) {
        return this.rawClient.pingOptionallyAuthd(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns a greeting message to verify the API is accessible. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> pingUnauthd() {
        return this.rawClient.pingUnauthd().thenApply(response -> response.body());
    }

    /**
     * Returns a greeting message to verify the API is accessible. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> pingUnauthd(RequestOptions requestOptions) {
        return this.rawClient.pingUnauthd(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns a health status message used for monitoring system availability and uptime. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> health() {
        return this.rawClient.health().thenApply(response -> response.body());
    }

    /**
     * Returns a health status message used for monitoring system availability and uptime. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> health(RequestOptions requestOptions) {
        return this.rawClient.health(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Test endpoint that intentionally fails for error handling validation and monitoring purposes. | () -&gt; (None)
     */
    public CompletableFuture<Object> failure() {
        return this.rawClient.failure().thenApply(response -> response.body());
    }

    /**
     * Test endpoint that intentionally fails for error handling validation and monitoring purposes. | () -&gt; (None)
     */
    public CompletableFuture<Object> failure(RequestOptions requestOptions) {
        return this.rawClient.failure(requestOptions).thenApply(response -> response.body());
    }
}
