/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperContactInfoClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperContactInfoClient rawClient;

    public AsyncShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperContactInfoClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the shipper contact information associated with the caller's ID. | () -&gt; (ShipperContact1)
     */
    public CompletableFuture<ShipperContact1> getCallerV1() {
        return this.rawClient.getCallerV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves the shipper contact information associated with the caller's ID. | () -&gt; (ShipperContact1)
     */
    public CompletableFuture<ShipperContact1> getCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getCallerV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for the caller's organization. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for the caller's organization. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listCourierContactsV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsV1(shipperOrgId).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listCourierContactsV1(
            String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listCourierContactsV1(shipperOrgId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the forwarder organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listForwarderContactsV1(String shipperOrgId) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the forwarder organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listForwarderContactsV1(
            String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listForwarderContactsV1(shipperOrgId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listOffPlatformContactsV1(String offChrtShipperOrgId) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public CompletableFuture<List<ShipperContact1>> listOffPlatformContactsV1(
            String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listOffPlatformContactsV1(offChrtShipperOrgId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it. | () -&gt; (ShipperContact1)
     */
    public CompletableFuture<ShipperContact1> getV1(String id) {
        return this.rawClient.getV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it. | () -&gt; (ShipperContact1)
     */
    public CompletableFuture<ShipperContact1> getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an on-platform shipper organization or user. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an on-platform shipper organization or user. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOnPlatformV1(
            ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an off-platform shipper using connection info. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an off-platform shipper using connection info. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOffPlatformV1(
            ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(
            String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient
                .updateV1(shipperContactInfoId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Deletes shipper contact information owned by the caller's organization. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String id) {
        return this.rawClient.deleteV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes shipper contact information owned by the caller's organization. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(id, requestOptions).thenApply(response -> response.body());
    }
}
