/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;

public class ShipperContactInfoClient {
    protected final ClientOptions clientOptions;

    private final RawShipperContactInfoClient rawClient;

    public ShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperContactInfoClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the shipper contact information associated with the caller's ID. | () -&gt; (ShipperContact1)
     */
    public ShipperContact1 getCallerV1() {
        return this.rawClient.getCallerV1().body();
    }

    /**
     * Retrieves the shipper contact information associated with the caller's ID. | () -&gt; (ShipperContact1)
     */
    public ShipperContact1 getCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getCallerV1(requestOptions).body();
    }

    /**
     * Lists all shipper contacts for the caller's organization. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listV1() {
        return this.rawClient.listV1().body();
    }

    /**
     * Lists all shipper contacts for the caller's organization. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listCourierContactsV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsV1(shipperOrgId).body();
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listCourierContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listCourierContactsV1(shipperOrgId, requestOptions)
                .body();
    }

    /**
     * Lists all shipper contacts accessible to the forwarder organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listForwarderContactsV1(String shipperOrgId) {
        return this.rawClient.listForwarderContactsV1(shipperOrgId).body();
    }

    /**
     * Lists all shipper contacts accessible to the forwarder organization for a specific on-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listForwarderContactsV1(String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listForwarderContactsV1(shipperOrgId, requestOptions)
                .body();
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listOffPlatformContactsV1(String offChrtShipperOrgId) {
        return this.rawClient.listOffPlatformContactsV1(offChrtShipperOrgId).body();
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper. | () -&gt; (list[ShipperContact1])
     */
    public List<ShipperContact1> listOffPlatformContactsV1(String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listOffPlatformContactsV1(offChrtShipperOrgId, requestOptions)
                .body();
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it. | () -&gt; (ShipperContact1)
     */
    public ShipperContact1 getV1(String id) {
        return this.rawClient.getV1(id).body();
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it. | () -&gt; (ShipperContact1)
     */
    public ShipperContact1 getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).body();
    }

    /**
     * Creates contact information for an on-platform shipper organization or user. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).body();
    }

    /**
     * Creates contact information for an on-platform shipper organization or user. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createOnPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).body();
    }

    /**
     * Creates contact information for an off-platform shipper using connection info. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).body();
    }

    /**
     * Creates contact information for an off-platform shipper using connection info. | (ShipperContactClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createOffPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).body();
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).body();
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).body();
    }

    /**
     * Updates existing shipper contact information owned by the caller's organization. | (ShipperContactClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(
            String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient
                .updateV1(shipperContactInfoId, request, requestOptions)
                .body();
    }

    /**
     * Deletes shipper contact information owned by the caller's organization. | () -&gt; (bool)
     */
    public boolean deleteV1(String id) {
        return this.rawClient.deleteV1(id).body();
    }

    /**
     * Deletes shipper contact information owned by the caller's organization. | () -&gt; (bool)
     */
    public boolean deleteV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(id, requestOptions).body();
    }
}
