/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskartifacts.requests.AddTaskArtifactReq;
import com.chrt.api.resources.taskartifacts.s3object.AsyncS3ObjectClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskArtifactsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskArtifactsClient rawClient;

    protected final Supplier<AsyncS3ObjectClient> s3ObjectClient;

    public AsyncTaskArtifactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskArtifactsClient(clientOptions);
        this.s3ObjectClient = Suppliers.memoize(() -> new AsyncS3ObjectClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskArtifactsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a new task artifact to a task. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | (AddTaskArtifactReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addToTaskV1(String taskId, AddTaskArtifactReq request) {
        return this.rawClient.addToTaskV1(taskId, request).thenApply(response -> response.body());
    }

    /**
     * Adds a new task artifact to a task. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | (AddTaskArtifactReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addToTaskV1(
            String taskId, AddTaskArtifactReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskV1(taskId, request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks a task artifact as COMPLETED. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> completeV1(String taskArtifactId) {
        return this.rawClient.completeV1(taskArtifactId).thenApply(response -> response.body());
    }

    /**
     * Marks a task artifact as COMPLETED. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> completeV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskArtifactId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks a task artifact as SKIPPED. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> skipV1(String taskArtifactId) {
        return this.rawClient.skipV1(taskArtifactId).thenApply(response -> response.body());
    }

    /**
     * Marks a task artifact as SKIPPED. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> skipV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskArtifactId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a task artifact. | authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskArtifactId) {
        return this.rawClient.deleteV1(taskArtifactId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task artifact. | authz_personas=[lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskArtifactId, requestOptions).thenApply(response -> response.body());
    }

    public AsyncS3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }
}
