/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts.s3object;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskartifacts.s3object.requests.BodyPostTaskArtifactsS3ObjectAddV1OortTaskArtifactsS3ObjectAddV1TaskArtifactIdPost;
import com.chrt.api.types.TaskArtifactS3ObjectMetadata1;
import java.io.File;
import java.io.InputStream;

public class S3ObjectClient {
    protected final ClientOptions clientOptions;

    private final RawS3ObjectClient rawClient;

    public S3ObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawS3ObjectClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawS3ObjectClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the metadata for a task artifact S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskArtifactS3ObjectMetadata1)
     */
    public TaskArtifactS3ObjectMetadata1 getS3ObjectMetadataV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient
                .getS3ObjectMetadataV1(taskArtifactS3ObjectMetadataId)
                .body();
    }

    /**
     * Retrieves the metadata for a task artifact S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskArtifactS3ObjectMetadata1)
     */
    public TaskArtifactS3ObjectMetadata1 getS3ObjectMetadataV1(
            String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getS3ObjectMetadataV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Streams a task artifact S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public InputStream getV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient.getV1(taskArtifactS3ObjectMetadataId).body();
    }

    /**
     * Streams a task artifact S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public InputStream getV1(String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Uploads an image file to a task artifact with automatic blurhash generation. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String taskArtifactId,
            File image,
            BodyPostTaskArtifactsS3ObjectAddV1OortTaskArtifactsS3ObjectAddV1TaskArtifactIdPost request) {
        return this.rawClient.addV1(taskArtifactId, image, request).body();
    }

    /**
     * Uploads an image file to a task artifact with automatic blurhash generation. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String taskArtifactId,
            File image,
            BodyPostTaskArtifactsS3ObjectAddV1OortTaskArtifactsS3ObjectAddV1TaskArtifactIdPost request,
            RequestOptions requestOptions) {
        return this.rawClient
                .addV1(taskArtifactId, image, request, requestOptions)
                .body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task artifact. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient.deleteV1(taskArtifactS3ObjectMetadataId).body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task artifact. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .body();
    }
}
