/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.expanded.AsyncExpandedClient;
import com.chrt.api.resources.taskgroups.requests.AddMessageReq;
import com.chrt.api.resources.taskgroups.requests.SetTaskOrderingReq;
import com.chrt.api.resources.taskgroups.requests.UpdateCourierOrgReq;
import com.chrt.api.resources.taskgroups.requests.UpdateDriverReq;
import com.chrt.api.resources.taskgroups.s3object.AsyncS3ObjectClient;
import com.chrt.api.resources.taskgroups.taskgroupid.AsyncTaskGroupIdClient;
import com.chrt.api.types.SetFlightInfoReq;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskGroupsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupsClient rawClient;

    protected final Supplier<AsyncTaskGroupIdClient> taskGroupIdClient;

    protected final Supplier<AsyncS3ObjectClient> s3ObjectClient;

    protected final Supplier<AsyncExpandedClient> expandedClient;

    public AsyncTaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupsClient(clientOptions);
        this.taskGroupIdClient = Suppliers.memoize(() -> new AsyncTaskGroupIdClient(clientOptions));
        this.s3ObjectClient = Suppliers.memoize(() -> new AsyncS3ObjectClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Starts a task group by transitioning it from STAGED to IN_PROGRESS and syncing related order state. | authz_personas=[courier_driver, lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Starts a task group by transitioning it from STAGED to IN_PROGRESS and syncing related order state. | authz_personas=[courier_driver, lig_owner_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sets the ordering of tasks within a task group. Requires complete list of task IDs in desired order. Completed tasks must be before staged tasks. | authz_personas=[lig_owner_operators] | (SetTaskOrderingReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets the ordering of tasks within a task group. Requires complete list of task IDs in desired order. Completed tasks must be before staged tasks. | authz_personas=[lig_owner_operators] | (SetTaskOrderingReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setTaskOrderingV1(
            String taskGroupId, SetTaskOrderingReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setTaskOrderingV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the driver assigned to a task group. | authz_personas=[courier_org_operators] | (UpdateDriverReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateDriverV1(String taskGroupId, UpdateDriverReq request) {
        return this.rawClient.updateDriverV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Updates the driver assigned to a task group. | authz_personas=[courier_org_operators] | (UpdateDriverReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateDriverV1(
            String taskGroupId, UpdateDriverReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateDriverV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Removes the driver from a task group (sets driver_id to null). | authz_personas=[courier_org_operators, courier_driver] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> removeDriverV1(String taskGroupId) {
        return this.rawClient.removeDriverV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Removes the driver from a task group (sets driver_id to null). | authz_personas=[courier_org_operators, courier_driver] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> removeDriverV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeDriverV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the courier organization assigned to a task group. | authz_personas=[forwarder_org_operators] | (UpdateCourierOrgReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Updates the courier organization assigned to a task group. | authz_personas=[forwarder_org_operators] | (UpdateCourierOrgReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateCourierOrgV1(
            String taskGroupId, UpdateCourierOrgReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateCourierOrgV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a task group. | authz_personas=[lig_owner_operators] | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId) {
        return this.rawClient.setFlightInfoV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a task group. | authz_personas=[lig_owner_operators] | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(String taskGroupId, SetFlightInfoReq request) {
        return this.rawClient.setFlightInfoV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Sets the flight number and/or fa_flight_ids on a task group. | authz_personas=[lig_owner_operators] | (SetFlightInfoReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> setFlightInfoV1(
            String taskGroupId, SetFlightInfoReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setFlightInfoV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Adds a message to a task group's message log. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (AddMessageReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> addMessageV1(String taskGroupId, AddMessageReq request) {
        return this.rawClient.addMessageV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Adds a message to a task group's message log. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (AddMessageReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> addMessageV1(
            String taskGroupId, AddMessageReq request, RequestOptions requestOptions) {
        return this.rawClient.addMessageV1(taskGroupId, request, requestOptions).thenApply(response -> response.body());
    }

    public AsyncTaskGroupIdClient taskGroupId() {
        return this.taskGroupIdClient.get();
    }

    public AsyncS3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }
}
