/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierDriverV1Request;
import com.chrt.api.resources.taskgroups.expanded.requests.ExpandedListForCourierOperatorsV1Request;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.TaskGroupExpanded;
import com.chrt.api.types.TaskGroupExpandedListRes;

public class ExpandedClient {
    protected final ClientOptions clientOptions;

    private final RawExpandedClient rawClient;

    public ExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves an expanded task group with optional related data for courier operators. | authz_personas=[courier_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierOperatorsV1(String taskGroupId) {
        return this.rawClient.forCourierOperatorsV1(taskGroupId).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for courier operators. | authz_personas=[courier_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forCourierOperatorsV1(taskGroupId, request).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for courier operators. | authz_personas=[courier_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierOperatorsV1(
            String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierOperatorsV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Retrieves an expanded task group with optional related data for courier drivers. | authz_personas=[courier_driver] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierDriverV1(String taskGroupId) {
        return this.rawClient.forCourierDriverV1(taskGroupId).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for courier drivers. | authz_personas=[courier_driver] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierDriverV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forCourierDriverV1(taskGroupId, request).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for courier drivers. | authz_personas=[courier_driver] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forCourierDriverV1(
            String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierDriverV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Retrieves an expanded task group with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forShipperOperatorsV1(String taskGroupId) {
        return this.rawClient.forShipperOperatorsV1(taskGroupId).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forShipperOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forShipperOperatorsV1(taskGroupId, request).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forShipperOperatorsV1(
            String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forShipperOperatorsV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Retrieves an expanded task group with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forForwarderOperatorsV1(String taskGroupId) {
        return this.rawClient.forForwarderOperatorsV1(taskGroupId).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forForwarderOperatorsV1(String taskGroupId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.forForwarderOperatorsV1(taskGroupId, request).body();
    }

    /**
     * Retrieves an expanded task group with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpanded)
     */
    public TaskGroupExpanded forForwarderOperatorsV1(
            String taskGroupId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .forForwarderOperatorsV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Lists expanded task groups for courier operators with filtering, sorting, and pagination. | authz_personas=[courier_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpandedListRes)
     */
    public TaskGroupExpandedListRes listForCourierOperatorsV1(ExpandedListForCourierOperatorsV1Request request) {
        return this.rawClient.listForCourierOperatorsV1(request).body();
    }

    /**
     * Lists expanded task groups for courier operators with filtering, sorting, and pagination. | authz_personas=[courier_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpandedListRes)
     */
    public TaskGroupExpandedListRes listForCourierOperatorsV1(
            ExpandedListForCourierOperatorsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierOperatorsV1(request, requestOptions).body();
    }

    /**
     * Lists expanded task groups for courier driver with filtering, sorting, and pagination. | authz_personas=[courier_driver] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpandedListRes)
     */
    public TaskGroupExpandedListRes listForCourierDriverV1(ExpandedListForCourierDriverV1Request request) {
        return this.rawClient.listForCourierDriverV1(request).body();
    }

    /**
     * Lists expanded task groups for courier driver with filtering, sorting, and pagination. | authz_personas=[courier_driver] | (OrderAndTaskGroupExpandedReq) -&gt; (TaskGroupExpandedListRes)
     */
    public TaskGroupExpandedListRes listForCourierDriverV1(
            ExpandedListForCourierDriverV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierDriverV1(request, requestOptions).body();
    }
}
