/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.taskgroupid;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupIdClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupIdClient rawClient;

    public AsyncTaskGroupIdClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupIdClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupIdClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> forCourierOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forCourierOperatorsV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> forCourierOperatorsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierOperatorsV1(orderIdOrShortId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> forCourierDriverV1(String orderIdOrShortId) {
        return this.rawClient.forCourierDriverV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> forCourierDriverV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierDriverV1(orderIdOrShortId, requestOptions)
                .thenApply(response -> response.body());
    }
}
