/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.taskgroupid;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawTaskGroupIdClient {
    protected final ClientOptions clientOptions;

    public RawTaskGroupIdClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> forCourierOperatorsV1(String orderIdOrShortId) {
        return forCourierOperatorsV1(orderIdOrShortId, null);
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> forCourierOperatorsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/task_group_id/for_courier_operators/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> forCourierDriverV1(String orderIdOrShortId) {
        return forCourierDriverV1(orderIdOrShortId, null);
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> forCourierDriverV1(String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/task_groups/task_group_id/for_courier_driver/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
