/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tasks.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskClientCreate1;
import com.chrt.api.types.TaskStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AddTaskToGroupReq.Builder.class)
public final class AddTaskToGroupReq {
    private final TaskClientCreate1 task;

    private final TaskStatusEnum1 status;

    private final int index;

    private final Map<String, Object> additionalProperties;

    private AddTaskToGroupReq(
            TaskClientCreate1 task, TaskStatusEnum1 status, int index, Map<String, Object> additionalProperties) {
        this.task = task;
        this.status = status;
        this.index = index;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task")
    public TaskClientCreate1 getTask() {
        return task;
    }

    /**
     * @return Initial status of the task. Must respect ordering constraints (COMPLETED tasks strictly before STAGED tasks).
     */
    @JsonProperty("status")
    public TaskStatusEnum1 getStatus() {
        return status;
    }

    /**
     * @return 0-based index of desired ordering
     */
    @JsonProperty("index")
    public int getIndex() {
        return index;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AddTaskToGroupReq && equalTo((AddTaskToGroupReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddTaskToGroupReq other) {
        return task.equals(other.task) && status.equals(other.status) && index == other.index;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.task, this.status, this.index);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskStage builder() {
        return new Builder();
    }

    public interface TaskStage {
        StatusStage task(@NotNull TaskClientCreate1 task);

        Builder from(AddTaskToGroupReq other);
    }

    public interface StatusStage {
        /**
         * <p>Initial status of the task. Must respect ordering constraints (COMPLETED tasks strictly before STAGED tasks).</p>
         */
        IndexStage status(@NotNull TaskStatusEnum1 status);
    }

    public interface IndexStage {
        /**
         * <p>0-based index of desired ordering</p>
         */
        _FinalStage index(int index);
    }

    public interface _FinalStage {
        AddTaskToGroupReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskStage, StatusStage, IndexStage, _FinalStage {
        private TaskClientCreate1 task;

        private TaskStatusEnum1 status;

        private int index;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AddTaskToGroupReq other) {
            task(other.getTask());
            status(other.getStatus());
            index(other.getIndex());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task")
        public StatusStage task(@NotNull TaskClientCreate1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        /**
         * <p>Initial status of the task. Must respect ordering constraints (COMPLETED tasks strictly before STAGED tasks).</p>
         * <p>Initial status of the task. Must respect ordering constraints (COMPLETED tasks strictly before STAGED tasks).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public IndexStage status(@NotNull TaskStatusEnum1 status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        /**
         * <p>0-based index of desired ordering</p>
         * <p>0-based index of desired ordering</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("index")
        public _FinalStage index(int index) {
            this.index = index;
            return this;
        }

        @java.lang.Override
        public AddTaskToGroupReq build() {
            return new AddTaskToGroupReq(task, status, index, additionalProperties);
        }
    }
}
