/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.tracking.devices.AsyncDevicesClient;
import com.chrt.api.resources.tracking.driver.AsyncDriverClient;
import com.chrt.api.resources.tracking.sessions.AsyncSessionsClient;
import com.chrt.api.resources.tracking.sharingsettings.AsyncSharingSettingsClient;
import com.chrt.api.resources.tracking.timeseries.AsyncTimeseriesClient;
import java.util.function.Supplier;

public class AsyncTrackingClient {
    protected final ClientOptions clientOptions;

    protected final Supplier<AsyncDevicesClient> devicesClient;

    protected final Supplier<AsyncDriverClient> driverClient;

    protected final Supplier<AsyncSessionsClient> sessionsClient;

    protected final Supplier<AsyncSharingSettingsClient> sharingSettingsClient;

    protected final Supplier<AsyncTimeseriesClient> timeseriesClient;

    public AsyncTrackingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.devicesClient = Suppliers.memoize(() -> new AsyncDevicesClient(clientOptions));
        this.driverClient = Suppliers.memoize(() -> new AsyncDriverClient(clientOptions));
        this.sessionsClient = Suppliers.memoize(() -> new AsyncSessionsClient(clientOptions));
        this.sharingSettingsClient = Suppliers.memoize(() -> new AsyncSharingSettingsClient(clientOptions));
        this.timeseriesClient = Suppliers.memoize(() -> new AsyncTimeseriesClient(clientOptions));
    }

    public AsyncDevicesClient devices() {
        return this.devicesClient.get();
    }

    public AsyncDriverClient driver() {
        return this.driverClient.get();
    }

    public AsyncSessionsClient sessions() {
        return this.sessionsClient.get();
    }

    public AsyncSharingSettingsClient sharingSettings() {
        return this.sharingSettingsClient.get();
    }

    public AsyncTimeseriesClient timeseries() {
        return this.timeseriesClient.get();
    }
}
