/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DevicesDeleteV1Request.Builder.class)
public final class DevicesDeleteV1Request {
    private final Optional<String> deviceId;

    private final Optional<String> deviceMacAddress;

    private final Map<String, Object> additionalProperties;

    private DevicesDeleteV1Request(
            Optional<String> deviceId, Optional<String> deviceMacAddress, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.deviceMacAddress = deviceMacAddress;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (deviceId == null) {
            return Optional.empty();
        }
        return deviceId;
    }

    @JsonIgnore
    public Optional<String> getDeviceMacAddress() {
        if (deviceMacAddress == null) {
            return Optional.empty();
        }
        return deviceMacAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("device_id")
    private Optional<String> _getDeviceId() {
        return deviceId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("device_mac_address")
    private Optional<String> _getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DevicesDeleteV1Request && equalTo((DevicesDeleteV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesDeleteV1Request other) {
        return deviceId.equals(other.deviceId) && deviceMacAddress.equals(other.deviceMacAddress);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.deviceId, this.deviceMacAddress);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> deviceId = Optional.empty();

        private Optional<String> deviceMacAddress = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DevicesDeleteV1Request other) {
            deviceId(other.getDeviceId());
            deviceMacAddress(other.getDeviceMacAddress());
            return this;
        }

        @JsonSetter(value = "device_id", nulls = Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            if (deviceId.isNull()) {
                this.deviceId = null;
            } else if (deviceId.isEmpty()) {
                this.deviceId = Optional.empty();
            } else {
                this.deviceId = Optional.of(deviceId.get());
            }
            return this;
        }

        @JsonSetter(value = "device_mac_address", nulls = Nulls.SKIP)
        public Builder deviceMacAddress(Optional<String> deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress;
            return this;
        }

        public Builder deviceMacAddress(String deviceMacAddress) {
            this.deviceMacAddress = Optional.ofNullable(deviceMacAddress);
            return this;
        }

        public Builder deviceMacAddress(Nullable<String> deviceMacAddress) {
            if (deviceMacAddress.isNull()) {
                this.deviceMacAddress = null;
            } else if (deviceMacAddress.isEmpty()) {
                this.deviceMacAddress = Optional.empty();
            } else {
                this.deviceMacAddress = Optional.of(deviceMacAddress.get());
            }
            return this;
        }

        public DevicesDeleteV1Request build() {
            return new DevicesDeleteV1Request(deviceId, deviceMacAddress, additionalProperties);
        }
    }
}
