/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DevicesLinkToCargoV1Request.Builder.class)
public final class DevicesLinkToCargoV1Request {
    private final String deviceMacAddress;

    private final String cargoId;

    private final Map<String, Object> additionalProperties;

    private DevicesLinkToCargoV1Request(
            String deviceMacAddress, String cargoId, Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.cargoId = cargoId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_mac_address")
    public String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DevicesLinkToCargoV1Request && equalTo((DevicesLinkToCargoV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesLinkToCargoV1Request other) {
        return deviceMacAddress.equals(other.deviceMacAddress) && cargoId.equals(other.cargoId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.cargoId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceMacAddressStage builder() {
        return new Builder();
    }

    public interface DeviceMacAddressStage {
        CargoIdStage deviceMacAddress(@NotNull String deviceMacAddress);

        Builder from(DevicesLinkToCargoV1Request other);
    }

    public interface CargoIdStage {
        _FinalStage cargoId(@NotNull String cargoId);
    }

    public interface _FinalStage {
        DevicesLinkToCargoV1Request build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceMacAddressStage, CargoIdStage, _FinalStage {
        private String deviceMacAddress;

        private String cargoId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DevicesLinkToCargoV1Request other) {
            deviceMacAddress(other.getDeviceMacAddress());
            cargoId(other.getCargoId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_mac_address")
        public CargoIdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public _FinalStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        public DevicesLinkToCargoV1Request build() {
            return new DevicesLinkToCargoV1Request(deviceMacAddress, cargoId, additionalProperties);
        }
    }
}
