/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TrackingDeviceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DevicesRegisterToOrgReq1.Builder.class)
public final class DevicesRegisterToOrgReq1 {
    private final String deviceMacAddress;

    private final Optional<TrackingDeviceTypeEnum1> type;

    private final Optional<String> comments;

    private final Map<String, Object> additionalProperties;

    private DevicesRegisterToOrgReq1(
            String deviceMacAddress,
            Optional<TrackingDeviceTypeEnum1> type,
            Optional<String> comments,
            Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.type = type;
        this.comments = comments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_mac_address")
    public String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @JsonIgnore
    public Optional<TrackingDeviceTypeEnum1> getType() {
        if (type == null) {
            return Optional.empty();
        }
        return type;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("type")
    private Optional<TrackingDeviceTypeEnum1> _getType() {
        return type;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DevicesRegisterToOrgReq1 && equalTo((DevicesRegisterToOrgReq1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesRegisterToOrgReq1 other) {
        return deviceMacAddress.equals(other.deviceMacAddress)
                && type.equals(other.type)
                && comments.equals(other.comments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.type, this.comments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceMacAddressStage builder() {
        return new Builder();
    }

    public interface DeviceMacAddressStage {
        _FinalStage deviceMacAddress(@NotNull String deviceMacAddress);

        Builder from(DevicesRegisterToOrgReq1 other);
    }

    public interface _FinalStage {
        DevicesRegisterToOrgReq1 build();

        _FinalStage type(Optional<TrackingDeviceTypeEnum1> type);

        _FinalStage type(TrackingDeviceTypeEnum1 type);

        _FinalStage type(Nullable<TrackingDeviceTypeEnum1> type);

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceMacAddressStage, _FinalStage {
        private String deviceMacAddress;

        private Optional<String> comments = Optional.empty();

        private Optional<TrackingDeviceTypeEnum1> type = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DevicesRegisterToOrgReq1 other) {
            deviceMacAddress(other.getDeviceMacAddress());
            type(other.getType());
            comments(other.getComments());
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_mac_address")
        public _FinalStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public _FinalStage type(Nullable<TrackingDeviceTypeEnum1> type) {
            if (type.isNull()) {
                this.type = null;
            } else if (type.isEmpty()) {
                this.type = Optional.empty();
            } else {
                this.type = Optional.of(type.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage type(TrackingDeviceTypeEnum1 type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<TrackingDeviceTypeEnum1> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public DevicesRegisterToOrgReq1 build() {
            return new DevicesRegisterToOrgReq1(deviceMacAddress, type, comments, additionalProperties);
        }
    }
}
