/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.driver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.DriverUpdateRes;
import com.chrt.api.types.LocationFeature;
import java.util.concurrent.CompletableFuture;

public class AsyncDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDriverClient rawClient;

    public AsyncDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Records driver location updates. Updates driver's last seen timestamp and location. Automatically records tracking data for all IN_PROGRESS task groups and their associated IN_TRANSIT cargos (cargo_by_driver). | (LocationFeature) -&gt; (DriverUpdateRes)
     */
    public CompletableFuture<DriverUpdateRes> updateV1(LocationFeature request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Records driver location updates. Updates driver's last seen timestamp and location. Automatically records tracking data for all IN_PROGRESS task groups and their associated IN_TRANSIT cargos (cargo_by_driver). | (LocationFeature) -&gt; (DriverUpdateRes)
     */
    public CompletableFuture<DriverUpdateRes> updateV1(LocationFeature request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }
}
