/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sessions;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sessions.requests.SessionCreateSessionRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionUpdateRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionsDeleteV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsGetV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsPauseRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsResumeRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsStartV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsTerminateV1Request;
import com.chrt.api.types.Session1;
import com.chrt.api.types.SessionDeleteResponse1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSessionsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSessionsClient rawClient;

    public AsyncSessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSessionsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSessionsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns all tracking sessions for the caller's organization. | () -&gt; (list[Session1])
     */
    public CompletableFuture<List<Session1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Returns all tracking sessions for the caller's organization. | () -&gt; (list[Session1])
     */
    public CompletableFuture<List<Session1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the caller's organization. | () -&gt; (Session1)
     */
    public CompletableFuture<Session1> getV1(SessionsGetV1Request request) {
        return this.rawClient.getV1(request).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the caller's organization. | () -&gt; (Session1)
     */
    public CompletableFuture<Session1> getV1(SessionsGetV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createSessionV1(SessionCreateSessionRequest1 request) {
        return this.rawClient.createSessionV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createSessionV1(
            SessionCreateSessionRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.createSessionV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionUpdateRequest1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(SessionUpdateRequest1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionUpdateRequest1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(SessionUpdateRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> startV1(SessionsStartV1Request request) {
        return this.rawClient.startV1(request).thenApply(response -> response.body());
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> startV1(SessionsStartV1Request request, RequestOptions requestOptions) {
        return this.rawClient.startV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> pauseRecordingV1(SessionsPauseRecordingV1Request request) {
        return this.rawClient.pauseRecordingV1(request).thenApply(response -> response.body());
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> pauseRecordingV1(
            SessionsPauseRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.pauseRecordingV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> resumeRecordingV1(SessionsResumeRecordingV1Request request) {
        return this.rawClient.resumeRecordingV1(request).thenApply(response -> response.body());
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> resumeRecordingV1(
            SessionsResumeRecordingV1Request request, RequestOptions requestOptions) {
        return this.rawClient.resumeRecordingV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> terminateV1(SessionsTerminateV1Request request) {
        return this.rawClient.terminateV1(request).thenApply(response -> response.body());
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> terminateV1(SessionsTerminateV1Request request, RequestOptions requestOptions) {
        return this.rawClient.terminateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionDeleteResponse1)
     */
    public CompletableFuture<SessionDeleteResponse1> deleteV1(SessionsDeleteV1Request request) {
        return this.rawClient.deleteV1(request).thenApply(response -> response.body());
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionDeleteResponse1)
     */
    public CompletableFuture<SessionDeleteResponse1> deleteV1(
            SessionsDeleteV1Request request, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(request, requestOptions).thenApply(response -> response.body());
    }
}
