/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sessions;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.sessions.requests.SessionCreateSessionRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionUpdateRequest1;
import com.chrt.api.resources.tracking.sessions.requests.SessionsDeleteV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsGetV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsPauseRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsResumeRecordingV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsStartV1Request;
import com.chrt.api.resources.tracking.sessions.requests.SessionsTerminateV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.Session1;
import com.chrt.api.types.SessionDeleteResponse1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawSessionsClient {
    protected final ClientOptions clientOptions;

    public RawSessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Returns all tracking sessions for the caller's organization. | () -&gt; (list[Session1])
     */
    public ChrtApiHttpResponse<List<Session1>> listV1() {
        return listV1(null);
    }

    /**
     * Returns all tracking sessions for the caller's organization. | () -&gt; (list[Session1])
     */
    public ChrtApiHttpResponse<List<Session1>> listV1(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/list/v1")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<Session1>>() {}),
                        response);
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the caller's organization. | () -&gt; (Session1)
     */
    public ChrtApiHttpResponse<Session1> getV1(SessionsGetV1Request request) {
        return getV1(request, null);
    }

    /**
     * Retrieves a single session by its ID. Access restricted to the caller's organization. | () -&gt; (Session1)
     */
    public ChrtApiHttpResponse<Session1> getV1(SessionsGetV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/get/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Session1.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> createSessionV1(SessionCreateSessionRequest1 request) {
        return createSessionV1(request, null);
    }

    /**
     * Creates a new tracking session for a device and links the device to it. The device must be registered to the caller's organization. | (SessionCreateSessionRequest1) -&gt; (PydanticObjectId)
     */
    public ChrtApiHttpResponse<String> createSessionV1(
            SessionCreateSessionRequest1 request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/create_session/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionUpdateRequest1) -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> updateV1(SessionUpdateRequest1 request) {
        return updateV1(request, null);
    }

    /**
     * Updates a session's comments and/or public visibility status. Can update one or both fields. | (SessionUpdateRequest1) -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> updateV1(SessionUpdateRequest1 request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/update/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> startV1(SessionsStartV1Request request) {
        return startV1(request, null);
    }

    /**
     * Starts location recording for a session by setting recording status to true. Sets the recording initiated timestamp on first start. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> startV1(SessionsStartV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/start/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> pauseRecordingV1(SessionsPauseRecordingV1Request request) {
        return pauseRecordingV1(request, null);
    }

    /**
     * Pauses location recording for a session by setting recording status to false. Device remains linked to the session. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> pauseRecordingV1(
            SessionsPauseRecordingV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/pause_recording/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> resumeRecordingV1(SessionsResumeRecordingV1Request request) {
        return resumeRecordingV1(request, null);
    }

    /**
     * Resumes location recording for a session by setting recording status to true. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> resumeRecordingV1(
            SessionsResumeRecordingV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/resume_recording/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> terminateV1(SessionsTerminateV1Request request) {
        return terminateV1(request, null);
    }

    /**
     * Terminates a session by setting recording to false and marking it as terminated. Unlinks the device from the session. | () -&gt; (bool)
     */
    public ChrtApiHttpResponse<Boolean> terminateV1(SessionsTerminateV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/terminate/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionDeleteResponse1)
     */
    public ChrtApiHttpResponse<SessionDeleteResponse1> deleteV1(SessionsDeleteV1Request request) {
        return deleteV1(request, null);
    }

    /**
     * Deletes a terminated session and all its associated timeseries data points. Only sessions marked as terminated can be deleted. | () -&gt; (SessionDeleteResponse1)
     */
    public ChrtApiHttpResponse<SessionDeleteResponse1> deleteV1(
            SessionsDeleteV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sessions/delete/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SessionDeleteResponse1.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
