/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sessions.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SessionCreateSessionRequest1.Builder.class)
public final class SessionCreateSessionRequest1 {
    private final String deviceMacAddress;

    private final Optional<String> comments;

    private final Map<String, Object> additionalProperties;

    private SessionCreateSessionRequest1(
            String deviceMacAddress, Optional<String> comments, Map<String, Object> additionalProperties) {
        this.deviceMacAddress = deviceMacAddress;
        this.comments = comments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_mac_address")
    public String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SessionCreateSessionRequest1 && equalTo((SessionCreateSessionRequest1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionCreateSessionRequest1 other) {
        return deviceMacAddress.equals(other.deviceMacAddress) && comments.equals(other.comments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.deviceMacAddress, this.comments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceMacAddressStage builder() {
        return new Builder();
    }

    public interface DeviceMacAddressStage {
        _FinalStage deviceMacAddress(@NotNull String deviceMacAddress);

        Builder from(SessionCreateSessionRequest1 other);
    }

    public interface _FinalStage {
        SessionCreateSessionRequest1 build();

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceMacAddressStage, _FinalStage {
        private String deviceMacAddress;

        private Optional<String> comments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SessionCreateSessionRequest1 other) {
            deviceMacAddress(other.getDeviceMacAddress());
            comments(other.getComments());
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_mac_address")
        public _FinalStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public SessionCreateSessionRequest1 build() {
            return new SessionCreateSessionRequest1(deviceMacAddress, comments, additionalProperties);
        }
    }
}
