/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sessions.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SessionUpdateRequest1.Builder.class)
public final class SessionUpdateRequest1 {
    private final String sessionId;

    private final Optional<String> comments;

    private final Optional<Boolean> deleteComments;

    private final Optional<Boolean> public_;

    private final Map<String, Object> additionalProperties;

    private SessionUpdateRequest1(
            String sessionId,
            Optional<String> comments,
            Optional<Boolean> deleteComments,
            Optional<Boolean> public_,
            Map<String, Object> additionalProperties) {
        this.sessionId = sessionId;
        this.comments = comments;
        this.deleteComments = deleteComments;
        this.public_ = public_;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("session_id")
    public String getSessionId() {
        return sessionId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("delete_comments")
    public Optional<Boolean> getDeleteComments() {
        return deleteComments;
    }

    @JsonIgnore
    public Optional<Boolean> getPublic() {
        if (public_ == null) {
            return Optional.empty();
        }
        return public_;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("public")
    private Optional<Boolean> _getPublic() {
        return public_;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SessionUpdateRequest1 && equalTo((SessionUpdateRequest1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionUpdateRequest1 other) {
        return sessionId.equals(other.sessionId)
                && comments.equals(other.comments)
                && deleteComments.equals(other.deleteComments)
                && public_.equals(other.public_);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.sessionId, this.comments, this.deleteComments, this.public_);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SessionIdStage builder() {
        return new Builder();
    }

    public interface SessionIdStage {
        _FinalStage sessionId(@NotNull String sessionId);

        Builder from(SessionUpdateRequest1 other);
    }

    public interface _FinalStage {
        SessionUpdateRequest1 build();

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);

        _FinalStage deleteComments(Optional<Boolean> deleteComments);

        _FinalStage deleteComments(Boolean deleteComments);

        _FinalStage public_(Optional<Boolean> public_);

        _FinalStage public_(Boolean public_);

        _FinalStage public_(Nullable<Boolean> public_);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SessionIdStage, _FinalStage {
        private String sessionId;

        private Optional<Boolean> public_ = Optional.empty();

        private Optional<Boolean> deleteComments = Optional.empty();

        private Optional<String> comments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SessionUpdateRequest1 other) {
            sessionId(other.getSessionId());
            comments(other.getComments());
            deleteComments(other.getDeleteComments());
            public_(other.getPublic());
            return this;
        }

        @java.lang.Override
        @JsonSetter("session_id")
        public _FinalStage sessionId(@NotNull String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage public_(Nullable<Boolean> public_) {
            if (public_.isNull()) {
                this.public_ = null;
            } else if (public_.isEmpty()) {
                this.public_ = Optional.empty();
            } else {
                this.public_ = Optional.of(public_.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "public", nulls = Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @java.lang.Override
        public _FinalStage deleteComments(Boolean deleteComments) {
            this.deleteComments = Optional.ofNullable(deleteComments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "delete_comments", nulls = Nulls.SKIP)
        public _FinalStage deleteComments(Optional<Boolean> deleteComments) {
            this.deleteComments = deleteComments;
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public SessionUpdateRequest1 build() {
            return new SessionUpdateRequest1(sessionId, comments, deleteComments, public_, additionalProperties);
        }
    }
}
