/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sharingsettings;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharingsettings.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSharingSettingsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSharingSettingsClient rawClient;

    public AsyncSharingSettingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSharingSettingsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSharingSettingsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient
                .taskGroupByDriverSharingSettingsV1(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. If authenticated, returns datasets the user has direct access to plus public datasets. If unauthenticated, returns only datasets with public=True. | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. If authenticated, returns datasets the user has direct access to plus public datasets. If unauthenticated, returns only datasets with public=True. | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).thenApply(response -> response.body());
    }
}
