/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydriver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverLastSeenV1Request;
import com.chrt.api.types.CargoByDriverDataPoint1;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoByDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCargoByDriverClient rawClient;

    public AsyncCargoByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoByDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCargoByDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDriverDataPoint1>> lastSeenV1(CargoByDriverLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDriverDataPoint1>> lastSeenV1(
            CargoByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public CompletableFuture<List<CargoByDriverDataPoint1>> dataPointsV1(CargoByDriverDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public CompletableFuture<List<CargoByDriverDataPoint1>> dataPointsV1(
            CargoByDriverDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDriverDataPoint1>> lastSeenPublicV1(
            CargoByDriverLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDriverDataPoint1>> lastSeenPublicV1(
            CargoByDriverLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public CompletableFuture<List<CargoByDriverDataPoint1>> dataPointsPublicV1(
            CargoByDriverDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public CompletableFuture<List<CargoByDriverDataPoint1>> dataPointsPublicV1(
            CargoByDriverDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).thenApply(response -> response.body());
    }
}
