/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydriver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydriver.requests.CargoByDriverLastSeenV1Request;
import com.chrt.api.types.CargoByDriverDataPoint1;
import java.util.List;
import java.util.Optional;

public class CargoByDriverClient {
    protected final ClientOptions clientOptions;

    private final RawCargoByDriverClient rawClient;

    public CargoByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCargoByDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCargoByDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public Optional<CargoByDriverDataPoint1> lastSeenV1(CargoByDriverLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).body();
    }

    /**
     * Returns the most recent driver location data point for cargo within a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public Optional<CargoByDriverDataPoint1> lastSeenV1(
            CargoByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public List<CargoByDriverDataPoint1> dataPointsV1(CargoByDriverDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public List<CargoByDriverDataPoint1> dataPointsV1(
            CargoByDriverDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).body();
    }

    /**
     * Returns the most recent driver location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public Optional<CargoByDriverDataPoint1> lastSeenPublicV1(CargoByDriverLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).body();
    }

    /**
     * Returns the most recent driver location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDriverDataPoint1 | None)
     */
    public Optional<CargoByDriverDataPoint1> lastSeenPublicV1(
            CargoByDriverLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public List<CargoByDriverDataPoint1> dataPointsPublicV1(CargoByDriverDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDriverDataPoint1])
     */
    public List<CargoByDriverDataPoint1> dataPointsPublicV1(
            CargoByDriverDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).body();
    }
}
