/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.taskgroupbydriver;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.requests.TaskGroupByDriverDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.requests.TaskGroupByDriverDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.requests.TaskGroupByDriverLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.requests.TaskGroupByDriverLastSeenV1Request;
import com.chrt.api.types.TaskGroupByDriverDataPoint1;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupByDriverClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupByDriverClient rawClient;

    public AsyncTaskGroupByDriverClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupByDriverClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupByDriverClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a task group. Access granted to courier or shipper organization. Data written by the driver update endpoint. | () -&gt; (TaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TaskGroupByDriverDataPoint1>> lastSeenV1(
            TaskGroupByDriverLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[TaskGroupByDriverDataPoint1])
     */
    public CompletableFuture<List<TaskGroupByDriverDataPoint1>> dataPointsV1(
            TaskGroupByDriverDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[TaskGroupByDriverDataPoint1])
     */
    public CompletableFuture<List<TaskGroupByDriverDataPoint1>> dataPointsV1(
            TaskGroupByDriverDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a public task group. No authentication required if task group has public visibility enabled via sharing settings. | () -&gt; (TaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TaskGroupByDriverDataPoint1>> lastSeenPublicV1(
            TaskGroupByDriverLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent driver location data point for a public task group. No authentication required if task group has public visibility enabled via sharing settings. | () -&gt; (TaskGroupByDriverDataPoint1 | None)
     */
    public CompletableFuture<Optional<TaskGroupByDriverDataPoint1>> lastSeenPublicV1(
            TaskGroupByDriverLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if task group has public visibility enabled via sharing settings. | () -&gt; (list[TaskGroupByDriverDataPoint1])
     */
    public CompletableFuture<List<TaskGroupByDriverDataPoint1>> dataPointsPublicV1(
            TaskGroupByDriverDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if task group has public visibility enabled via sharing settings. | () -&gt; (list[TaskGroupByDriverDataPoint1])
     */
    public CompletableFuture<List<TaskGroupByDriverDataPoint1>> dataPointsPublicV1(
            TaskGroupByDriverDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).thenApply(response -> response.body());
    }
}
