/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.utils;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.utils.requests.UtilsGetTimezoneV1Request;
import com.chrt.api.types.TimezoneResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncUtilsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawUtilsClient rawClient;

    public AsyncUtilsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawUtilsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawUtilsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the IANA timezone identifier (e.g., 'America/Los_Angeles') for the given latitude and longitude coordinates. Falls back to closest timezone if the point is in the ocean or at an edge. | () -&gt; (TimezoneResponse)
     */
    public CompletableFuture<TimezoneResponse> getTimezoneV1(UtilsGetTimezoneV1Request request) {
        return this.rawClient.getTimezoneV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the IANA timezone identifier (e.g., 'America/Los_Angeles') for the given latitude and longitude coordinates. Falls back to closest timezone if the point is in the ocean or at an edge. | () -&gt; (TimezoneResponse)
     */
    public CompletableFuture<TimezoneResponse> getTimezoneV1(
            UtilsGetTimezoneV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getTimezoneV1(request, requestOptions).thenApply(response -> response.body());
    }
}
