/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CargoByDriverSharingSettings1.Builder.class)
public final class CargoByDriverSharingSettings1 {
    private final int schemaVersion;

    private final String taskGroupId;

    private final String cargoId;

    private final String driverId;

    private final Optional<Boolean> public_;

    private final Optional<String> lastChangedByUserId;

    private final Optional<String> lastChangedByOrgId;

    private final Optional<OffsetDateTime> lastChangedTimestamp;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private CargoByDriverSharingSettings1(
            int schemaVersion,
            String taskGroupId,
            String cargoId,
            String driverId,
            Optional<Boolean> public_,
            Optional<String> lastChangedByUserId,
            Optional<String> lastChangedByOrgId,
            Optional<OffsetDateTime> lastChangedTimestamp,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.taskGroupId = taskGroupId;
        this.cargoId = cargoId;
        this.driverId = driverId;
        this.public_ = public_;
        this.lastChangedByUserId = lastChangedByUserId;
        this.lastChangedByOrgId = lastChangedByOrgId;
        this.lastChangedTimestamp = lastChangedTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @JsonProperty("driver_id")
    public String getDriverId() {
        return driverId;
    }

    @JsonProperty("public")
    public Optional<Boolean> getPublic() {
        return public_;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getLastChangedByUserId() {
        if (lastChangedByUserId == null) {
            return Optional.empty();
        }
        return lastChangedByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getLastChangedByOrgId() {
        if (lastChangedByOrgId == null) {
            return Optional.empty();
        }
        return lastChangedByOrgId;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastChangedTimestamp() {
        if (lastChangedTimestamp == null) {
            return Optional.empty();
        }
        return lastChangedTimestamp;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_changed_by_user_id")
    private Optional<String> _getLastChangedByUserId() {
        return lastChangedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_changed_by_org_id")
    private Optional<String> _getLastChangedByOrgId() {
        return lastChangedByOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_changed_timestamp")
    private Optional<OffsetDateTime> _getLastChangedTimestamp() {
        return lastChangedTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CargoByDriverSharingSettings1 && equalTo((CargoByDriverSharingSettings1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDriverSharingSettings1 other) {
        return schemaVersion == other.schemaVersion
                && taskGroupId.equals(other.taskGroupId)
                && cargoId.equals(other.cargoId)
                && driverId.equals(other.driverId)
                && public_.equals(other.public_)
                && lastChangedByUserId.equals(other.lastChangedByUserId)
                && lastChangedByOrgId.equals(other.lastChangedByOrgId)
                && lastChangedTimestamp.equals(other.lastChangedTimestamp)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.taskGroupId,
                this.cargoId,
                this.driverId,
                this.public_,
                this.lastChangedByUserId,
                this.lastChangedByOrgId,
                this.lastChangedTimestamp,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        TaskGroupIdStage schemaVersion(int schemaVersion);

        Builder from(CargoByDriverSharingSettings1 other);
    }

    public interface TaskGroupIdStage {
        CargoIdStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface CargoIdStage {
        DriverIdStage cargoId(@NotNull String cargoId);
    }

    public interface DriverIdStage {
        IdStage driverId(@NotNull String driverId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        CargoByDriverSharingSettings1 build();

        _FinalStage public_(Optional<Boolean> public_);

        _FinalStage public_(Boolean public_);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage lastChangedByUserId(Optional<String> lastChangedByUserId);

        _FinalStage lastChangedByUserId(String lastChangedByUserId);

        _FinalStage lastChangedByUserId(Nullable<String> lastChangedByUserId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage lastChangedByOrgId(Optional<String> lastChangedByOrgId);

        _FinalStage lastChangedByOrgId(String lastChangedByOrgId);

        _FinalStage lastChangedByOrgId(Nullable<String> lastChangedByOrgId);

        _FinalStage lastChangedTimestamp(Optional<OffsetDateTime> lastChangedTimestamp);

        _FinalStage lastChangedTimestamp(OffsetDateTime lastChangedTimestamp);

        _FinalStage lastChangedTimestamp(Nullable<OffsetDateTime> lastChangedTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, TaskGroupIdStage, CargoIdStage, DriverIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String taskGroupId;

        private String cargoId;

        private String driverId;

        private String id;

        private Optional<OffsetDateTime> lastChangedTimestamp = Optional.empty();

        private Optional<String> lastChangedByOrgId = Optional.empty();

        private Optional<String> lastChangedByUserId = Optional.empty();

        private Optional<Boolean> public_ = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CargoByDriverSharingSettings1 other) {
            schemaVersion(other.getSchemaVersion());
            taskGroupId(other.getTaskGroupId());
            cargoId(other.getCargoId());
            driverId(other.getDriverId());
            public_(other.getPublic());
            lastChangedByUserId(other.getLastChangedByUserId());
            lastChangedByOrgId(other.getLastChangedByOrgId());
            lastChangedTimestamp(other.getLastChangedTimestamp());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public TaskGroupIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public CargoIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public DriverIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_id")
        public IdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage lastChangedTimestamp(Nullable<OffsetDateTime> lastChangedTimestamp) {
            if (lastChangedTimestamp.isNull()) {
                this.lastChangedTimestamp = null;
            } else if (lastChangedTimestamp.isEmpty()) {
                this.lastChangedTimestamp = Optional.empty();
            } else {
                this.lastChangedTimestamp = Optional.of(lastChangedTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastChangedTimestamp(OffsetDateTime lastChangedTimestamp) {
            this.lastChangedTimestamp = Optional.ofNullable(lastChangedTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_changed_timestamp", nulls = Nulls.SKIP)
        public _FinalStage lastChangedTimestamp(Optional<OffsetDateTime> lastChangedTimestamp) {
            this.lastChangedTimestamp = lastChangedTimestamp;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastChangedByOrgId(Nullable<String> lastChangedByOrgId) {
            if (lastChangedByOrgId.isNull()) {
                this.lastChangedByOrgId = null;
            } else if (lastChangedByOrgId.isEmpty()) {
                this.lastChangedByOrgId = Optional.empty();
            } else {
                this.lastChangedByOrgId = Optional.of(lastChangedByOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastChangedByOrgId(String lastChangedByOrgId) {
            this.lastChangedByOrgId = Optional.ofNullable(lastChangedByOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_changed_by_org_id", nulls = Nulls.SKIP)
        public _FinalStage lastChangedByOrgId(Optional<String> lastChangedByOrgId) {
            this.lastChangedByOrgId = lastChangedByOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastChangedByUserId(Nullable<String> lastChangedByUserId) {
            if (lastChangedByUserId.isNull()) {
                this.lastChangedByUserId = null;
            } else if (lastChangedByUserId.isEmpty()) {
                this.lastChangedByUserId = Optional.empty();
            } else {
                this.lastChangedByUserId = Optional.of(lastChangedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastChangedByUserId(String lastChangedByUserId) {
            this.lastChangedByUserId = Optional.ofNullable(lastChangedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_changed_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage lastChangedByUserId(Optional<String> lastChangedByUserId) {
            this.lastChangedByUserId = lastChangedByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "public", nulls = Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @java.lang.Override
        public CargoByDriverSharingSettings1 build() {
            return new CargoByDriverSharingSettings1(
                    schemaVersion,
                    taskGroupId,
                    cargoId,
                    driverId,
                    public_,
                    lastChangedByUserId,
                    lastChangedByOrgId,
                    lastChangedTimestamp,
                    id,
                    additionalProperties);
        }
    }
}
