/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FlightInfoForTaskRes.Builder.class)
public final class FlightInfoForTaskRes {
    private final Optional<String> flightNumber;

    private final Optional<List<String>> faFlightIds;

    private final Map<String, Object> additionalProperties;

    private FlightInfoForTaskRes(
            Optional<String> flightNumber,
            Optional<List<String>> faFlightIds,
            Map<String, Object> additionalProperties) {
        this.flightNumber = flightNumber;
        this.faFlightIds = faFlightIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (flightNumber == null) {
            return Optional.empty();
        }
        return flightNumber;
    }

    @JsonProperty("fa_flight_ids")
    public Optional<List<String>> getFaFlightIds() {
        return faFlightIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("flight_number")
    private Optional<String> _getFlightNumber() {
        return flightNumber;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FlightInfoForTaskRes && equalTo((FlightInfoForTaskRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlightInfoForTaskRes other) {
        return flightNumber.equals(other.flightNumber) && faFlightIds.equals(other.faFlightIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.flightNumber, this.faFlightIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> flightNumber = Optional.empty();

        private Optional<List<String>> faFlightIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(FlightInfoForTaskRes other) {
            flightNumber(other.getFlightNumber());
            faFlightIds(other.getFaFlightIds());
            return this;
        }

        @JsonSetter(value = "flight_number", nulls = Nulls.SKIP)
        public Builder flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        public Builder flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        public Builder flightNumber(Nullable<String> flightNumber) {
            if (flightNumber.isNull()) {
                this.flightNumber = null;
            } else if (flightNumber.isEmpty()) {
                this.flightNumber = Optional.empty();
            } else {
                this.flightNumber = Optional.of(flightNumber.get());
            }
            return this;
        }

        @JsonSetter(value = "fa_flight_ids", nulls = Nulls.SKIP)
        public Builder faFlightIds(Optional<List<String>> faFlightIds) {
            this.faFlightIds = faFlightIds;
            return this;
        }

        public Builder faFlightIds(List<String> faFlightIds) {
            this.faFlightIds = Optional.ofNullable(faFlightIds);
            return this;
        }

        public FlightInfoForTaskRes build() {
            return new FlightInfoForTaskRes(flightNumber, faFlightIds, additionalProperties);
        }
    }
}
