/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LineItemGroup1.Builder.class)
public final class LineItemGroup1 {
    private final int schemaVersion;

    private final String id;

    private final Optional<String> taskGroupId;

    private final Optional<String> rateSheetId;

    private final List<LineItem1> lineItems;

    private final Optional<List<String>> lineItemGroupS3ObjectMetadataIds;

    private final Optional<String> statementId;

    private final String ownedByOrgId;

    private final PaymentVectorTypeEnum1 paymentVectorType;

    private final SettlementTypeEnum1 settlementType;

    private final Optional<String> paymentOriginOrgId;

    private final Optional<String> paymentOriginOffChrtShipperOrgId;

    private final Optional<String> paymentDestinationOrgId;

    private final Optional<String> paymentDestinationDriverId;

    private final Optional<LineItemGroupStatusEnum1> status;

    private final Optional<List<LineItemGroupMessage1>> messages;

    private final Map<String, Object> additionalProperties;

    private LineItemGroup1(
            int schemaVersion,
            String id,
            Optional<String> taskGroupId,
            Optional<String> rateSheetId,
            List<LineItem1> lineItems,
            Optional<List<String>> lineItemGroupS3ObjectMetadataIds,
            Optional<String> statementId,
            String ownedByOrgId,
            PaymentVectorTypeEnum1 paymentVectorType,
            SettlementTypeEnum1 settlementType,
            Optional<String> paymentOriginOrgId,
            Optional<String> paymentOriginOffChrtShipperOrgId,
            Optional<String> paymentDestinationOrgId,
            Optional<String> paymentDestinationDriverId,
            Optional<LineItemGroupStatusEnum1> status,
            Optional<List<LineItemGroupMessage1>> messages,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.taskGroupId = taskGroupId;
        this.rateSheetId = rateSheetId;
        this.lineItems = lineItems;
        this.lineItemGroupS3ObjectMetadataIds = lineItemGroupS3ObjectMetadataIds;
        this.statementId = statementId;
        this.ownedByOrgId = ownedByOrgId;
        this.paymentVectorType = paymentVectorType;
        this.settlementType = settlementType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.status = status;
        this.messages = messages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonIgnore
    public Optional<String> getTaskGroupId() {
        if (taskGroupId == null) {
            return Optional.empty();
        }
        return taskGroupId;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (rateSheetId == null) {
            return Optional.empty();
        }
        return rateSheetId;
    }

    @JsonProperty("line_items")
    public List<LineItem1> getLineItems() {
        return lineItems;
    }

    @JsonProperty("line_item_group_s3_object_metadata_ids")
    public Optional<List<String>> getLineItemGroupS3ObjectMetadataIds() {
        return lineItemGroupS3ObjectMetadataIds;
    }

    @JsonIgnore
    public Optional<String> getStatementId() {
        if (statementId == null) {
            return Optional.empty();
        }
        return statementId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("owned_by_org_id")
    public String getOwnedByOrgId() {
        return ownedByOrgId;
    }

    @JsonProperty("payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return paymentVectorType;
    }

    @JsonProperty("settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return settlementType;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOffChrtShipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return paymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return paymentDestinationDriverId;
    }

    @JsonProperty("status")
    public Optional<LineItemGroupStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("messages")
    public Optional<List<LineItemGroupMessage1>> getMessages() {
        return messages;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_group_id")
    private Optional<String> _getTaskGroupId() {
        return taskGroupId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return rateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_id")
    private Optional<String> _getStatementId() {
        return statementId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return paymentOriginOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return paymentDestinationOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return paymentDestinationDriverId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LineItemGroup1 && equalTo((LineItemGroup1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemGroup1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && taskGroupId.equals(other.taskGroupId)
                && rateSheetId.equals(other.rateSheetId)
                && lineItems.equals(other.lineItems)
                && lineItemGroupS3ObjectMetadataIds.equals(other.lineItemGroupS3ObjectMetadataIds)
                && statementId.equals(other.statementId)
                && ownedByOrgId.equals(other.ownedByOrgId)
                && paymentVectorType.equals(other.paymentVectorType)
                && settlementType.equals(other.settlementType)
                && paymentOriginOrgId.equals(other.paymentOriginOrgId)
                && paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId)
                && paymentDestinationOrgId.equals(other.paymentDestinationOrgId)
                && paymentDestinationDriverId.equals(other.paymentDestinationDriverId)
                && status.equals(other.status)
                && messages.equals(other.messages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.taskGroupId,
                this.rateSheetId,
                this.lineItems,
                this.lineItemGroupS3ObjectMetadataIds,
                this.statementId,
                this.ownedByOrgId,
                this.paymentVectorType,
                this.settlementType,
                this.paymentOriginOrgId,
                this.paymentOriginOffChrtShipperOrgId,
                this.paymentDestinationOrgId,
                this.paymentDestinationDriverId,
                this.status,
                this.messages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(LineItemGroup1 other);
    }

    public interface IdStage {
        OwnedByOrgIdStage id(@NotNull String id);
    }

    public interface OwnedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId);
    }

    public interface PaymentVectorTypeStage {
        SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType);
    }

    public interface SettlementTypeStage {
        _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType);
    }

    public interface _FinalStage {
        LineItemGroup1 build();

        _FinalStage taskGroupId(Optional<String> taskGroupId);

        _FinalStage taskGroupId(String taskGroupId);

        _FinalStage taskGroupId(Nullable<String> taskGroupId);

        _FinalStage rateSheetId(Optional<String> rateSheetId);

        _FinalStage rateSheetId(String rateSheetId);

        _FinalStage rateSheetId(Nullable<String> rateSheetId);

        _FinalStage lineItems(List<LineItem1> lineItems);

        _FinalStage addLineItems(LineItem1 lineItems);

        _FinalStage addAllLineItems(List<LineItem1> lineItems);

        _FinalStage lineItemGroupS3ObjectMetadataIds(Optional<List<String>> lineItemGroupS3ObjectMetadataIds);

        _FinalStage lineItemGroupS3ObjectMetadataIds(List<String> lineItemGroupS3ObjectMetadataIds);

        _FinalStage statementId(Optional<String> statementId);

        _FinalStage statementId(String statementId);

        _FinalStage statementId(Nullable<String> statementId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(String paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId);

        _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId);

        _FinalStage status(Optional<LineItemGroupStatusEnum1> status);

        _FinalStage status(LineItemGroupStatusEnum1 status);

        _FinalStage messages(Optional<List<LineItemGroupMessage1>> messages);

        _FinalStage messages(List<LineItemGroupMessage1> messages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    OwnedByOrgIdStage,
                    PaymentVectorTypeStage,
                    SettlementTypeStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String ownedByOrgId;

        private PaymentVectorTypeEnum1 paymentVectorType;

        private SettlementTypeEnum1 settlementType;

        private Optional<List<LineItemGroupMessage1>> messages = Optional.empty();

        private Optional<LineItemGroupStatusEnum1> status = Optional.empty();

        private Optional<String> paymentDestinationDriverId = Optional.empty();

        private Optional<String> paymentDestinationOrgId = Optional.empty();

        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();

        private Optional<String> paymentOriginOrgId = Optional.empty();

        private Optional<String> statementId = Optional.empty();

        private Optional<List<String>> lineItemGroupS3ObjectMetadataIds = Optional.empty();

        private List<LineItem1> lineItems = new ArrayList<>();

        private Optional<String> rateSheetId = Optional.empty();

        private Optional<String> taskGroupId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LineItemGroup1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            taskGroupId(other.getTaskGroupId());
            rateSheetId(other.getRateSheetId());
            lineItems(other.getLineItems());
            lineItemGroupS3ObjectMetadataIds(other.getLineItemGroupS3ObjectMetadataIds());
            statementId(other.getStatementId());
            ownedByOrgId(other.getOwnedByOrgId());
            paymentVectorType(other.getPaymentVectorType());
            settlementType(other.getSettlementType());
            paymentOriginOrgId(other.getPaymentOriginOrgId());
            paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            status(other.getStatus());
            messages(other.getMessages());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OwnedByOrgIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("owned_by_org_id")
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId) {
            this.ownedByOrgId = Objects.requireNonNull(ownedByOrgId, "ownedByOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_vector_type")
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("settlement_type")
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage messages(List<LineItemGroupMessage1> messages) {
            this.messages = Optional.ofNullable(messages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "messages", nulls = Nulls.SKIP)
        public _FinalStage messages(Optional<List<LineItemGroupMessage1>> messages) {
            this.messages = messages;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(LineItemGroupStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<LineItemGroupStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            if (paymentDestinationDriverId.isNull()) {
                this.paymentDestinationDriverId = null;
            } else if (paymentDestinationDriverId.isEmpty()) {
                this.paymentDestinationDriverId = Optional.empty();
            } else {
                this.paymentDestinationDriverId = Optional.of(paymentDestinationDriverId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_destination_driver_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            if (paymentDestinationOrgId.isNull()) {
                this.paymentDestinationOrgId = null;
            } else if (paymentDestinationOrgId.isEmpty()) {
                this.paymentDestinationOrgId = Optional.empty();
            } else {
                this.paymentDestinationOrgId = Optional.of(paymentDestinationOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_destination_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            if (paymentOriginOffChrtShipperOrgId.isNull()) {
                this.paymentOriginOffChrtShipperOrgId = null;
            } else if (paymentOriginOffChrtShipperOrgId.isEmpty()) {
                this.paymentOriginOffChrtShipperOrgId = Optional.empty();
            } else {
                this.paymentOriginOffChrtShipperOrgId = Optional.of(paymentOriginOffChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_origin_off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            if (paymentOriginOrgId.isNull()) {
                this.paymentOriginOrgId = null;
            } else if (paymentOriginOrgId.isEmpty()) {
                this.paymentOriginOrgId = Optional.empty();
            } else {
                this.paymentOriginOrgId = Optional.of(paymentOriginOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_origin_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage statementId(Nullable<String> statementId) {
            if (statementId.isNull()) {
                this.statementId = null;
            } else if (statementId.isEmpty()) {
                this.statementId = Optional.empty();
            } else {
                this.statementId = Optional.of(statementId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage statementId(String statementId) {
            this.statementId = Optional.ofNullable(statementId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "statement_id", nulls = Nulls.SKIP)
        public _FinalStage statementId(Optional<String> statementId) {
            this.statementId = statementId;
            return this;
        }

        @java.lang.Override
        public _FinalStage lineItemGroupS3ObjectMetadataIds(List<String> lineItemGroupS3ObjectMetadataIds) {
            this.lineItemGroupS3ObjectMetadataIds = Optional.ofNullable(lineItemGroupS3ObjectMetadataIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_item_group_s3_object_metadata_ids", nulls = Nulls.SKIP)
        public _FinalStage lineItemGroupS3ObjectMetadataIds(Optional<List<String>> lineItemGroupS3ObjectMetadataIds) {
            this.lineItemGroupS3ObjectMetadataIds = lineItemGroupS3ObjectMetadataIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_items", nulls = Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            if (rateSheetId.isNull()) {
                this.rateSheetId = null;
            } else if (rateSheetId.isEmpty()) {
                this.rateSheetId = Optional.empty();
            } else {
                this.rateSheetId = Optional.of(rateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupId(Nullable<String> taskGroupId) {
            if (taskGroupId.isNull()) {
                this.taskGroupId = null;
            } else if (taskGroupId.isEmpty()) {
                this.taskGroupId = Optional.empty();
            } else {
                this.taskGroupId = Optional.of(taskGroupId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupId(String taskGroupId) {
            this.taskGroupId = Optional.ofNullable(taskGroupId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_id", nulls = Nulls.SKIP)
        public _FinalStage taskGroupId(Optional<String> taskGroupId) {
            this.taskGroupId = taskGroupId;
            return this;
        }

        @java.lang.Override
        public LineItemGroup1 build() {
            return new LineItemGroup1(
                    schemaVersion,
                    id,
                    taskGroupId,
                    rateSheetId,
                    lineItems,
                    lineItemGroupS3ObjectMetadataIds,
                    statementId,
                    ownedByOrgId,
                    paymentVectorType,
                    settlementType,
                    paymentOriginOrgId,
                    paymentOriginOffChrtShipperOrgId,
                    paymentDestinationOrgId,
                    paymentDestinationDriverId,
                    status,
                    messages,
                    additionalProperties);
        }
    }
}
