/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LocationFeature.Builder.class)
public final class LocationFeature {
    private final Optional<List<Object>> bbox;

    private final Geometry geometry;

    private final Optional<LocationProperties> properties;

    private final Optional<Id> id;

    private final Map<String, Object> additionalProperties;

    private LocationFeature(
            Optional<List<Object>> bbox,
            Geometry geometry,
            Optional<LocationProperties> properties,
            Optional<Id> id,
            Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.geometry = geometry;
        this.properties = properties;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (bbox == null) {
            return Optional.empty();
        }
        return bbox;
    }

    @JsonProperty("type")
    public String getType() {
        return "Feature";
    }

    @JsonProperty("geometry")
    public Geometry getGeometry() {
        return geometry;
    }

    @JsonIgnore
    public Optional<LocationProperties> getProperties() {
        if (properties == null) {
            return Optional.empty();
        }
        return properties;
    }

    @JsonIgnore
    public Optional<Id> getId() {
        if (id == null) {
            return Optional.empty();
        }
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("bbox")
    private Optional<List<Object>> _getBbox() {
        return bbox;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("properties")
    private Optional<LocationProperties> _getProperties() {
        return properties;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("id")
    private Optional<Id> _getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LocationFeature && equalTo((LocationFeature) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocationFeature other) {
        return bbox.equals(other.bbox)
                && geometry.equals(other.geometry)
                && properties.equals(other.properties)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.bbox, this.geometry, this.properties, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GeometryStage builder() {
        return new Builder();
    }

    public interface GeometryStage {
        _FinalStage geometry(@NotNull Geometry geometry);

        Builder from(LocationFeature other);
    }

    public interface _FinalStage {
        LocationFeature build();

        _FinalStage bbox(Optional<List<Object>> bbox);

        _FinalStage bbox(List<Object> bbox);

        _FinalStage bbox(Nullable<List<Object>> bbox);

        _FinalStage properties(Optional<LocationProperties> properties);

        _FinalStage properties(LocationProperties properties);

        _FinalStage properties(Nullable<LocationProperties> properties);

        _FinalStage id(Optional<Id> id);

        _FinalStage id(Id id);

        _FinalStage id(Nullable<Id> id);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements GeometryStage, _FinalStage {
        private Geometry geometry;

        private Optional<Id> id = Optional.empty();

        private Optional<LocationProperties> properties = Optional.empty();

        private Optional<List<Object>> bbox = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LocationFeature other) {
            bbox(other.getBbox());
            geometry(other.getGeometry());
            properties(other.getProperties());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("geometry")
        public _FinalStage geometry(@NotNull Geometry geometry) {
            this.geometry = Objects.requireNonNull(geometry, "geometry must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage id(Nullable<Id> id) {
            if (id.isNull()) {
                this.id = null;
            } else if (id.isEmpty()) {
                this.id = Optional.empty();
            } else {
                this.id = Optional.of(id.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage id(Id id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<Id> id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        public _FinalStage properties(Nullable<LocationProperties> properties) {
            if (properties.isNull()) {
                this.properties = null;
            } else if (properties.isEmpty()) {
                this.properties = Optional.empty();
            } else {
                this.properties = Optional.of(properties.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage properties(LocationProperties properties) {
            this.properties = Optional.ofNullable(properties);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "properties", nulls = Nulls.SKIP)
        public _FinalStage properties(Optional<LocationProperties> properties) {
            this.properties = properties;
            return this;
        }

        @java.lang.Override
        public _FinalStage bbox(Nullable<List<Object>> bbox) {
            if (bbox.isNull()) {
                this.bbox = null;
            } else if (bbox.isEmpty()) {
                this.bbox = Optional.empty();
            } else {
                this.bbox = Optional.of(bbox.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "bbox", nulls = Nulls.SKIP)
        public _FinalStage bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        @java.lang.Override
        public LocationFeature build() {
            return new LocationFeature(bbox, geometry, properties, id, additionalProperties);
        }
    }
}
