/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftExpanded.Builder.class)
public final class OrderDraftExpanded {
    private final Order1 order;

    private final Optional<String> forwarderOrgCompanyName;

    private final Optional<String> forwarderOrgHandle;

    private final Optional<String> shipperOrgCompanyName;

    private final Optional<String> offChrtShipperOrgCompanyName;

    private final Optional<List<TaskGroupExpanded>> taskGroupsExpanded;

    private final Optional<List<Cargo1>> cargos;

    private final Map<String, Object> additionalProperties;

    private OrderDraftExpanded(
            Order1 order,
            Optional<String> forwarderOrgCompanyName,
            Optional<String> forwarderOrgHandle,
            Optional<String> shipperOrgCompanyName,
            Optional<String> offChrtShipperOrgCompanyName,
            Optional<List<TaskGroupExpanded>> taskGroupsExpanded,
            Optional<List<Cargo1>> cargos,
            Map<String, Object> additionalProperties) {
        this.order = order;
        this.forwarderOrgCompanyName = forwarderOrgCompanyName;
        this.forwarderOrgHandle = forwarderOrgHandle;
        this.shipperOrgCompanyName = shipperOrgCompanyName;
        this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
        this.taskGroupsExpanded = taskGroupsExpanded;
        this.cargos = cargos;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order")
    public Order1 getOrder() {
        return order;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgCompanyName() {
        if (forwarderOrgCompanyName == null) {
            return Optional.empty();
        }
        return forwarderOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgHandle() {
        if (forwarderOrgHandle == null) {
            return Optional.empty();
        }
        return forwarderOrgHandle;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgCompanyName() {
        if (shipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return shipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgCompanyName() {
        if (offChrtShipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<List<TaskGroupExpanded>> getTaskGroupsExpanded() {
        if (taskGroupsExpanded == null) {
            return Optional.empty();
        }
        return taskGroupsExpanded;
    }

    @JsonIgnore
    public Optional<List<Cargo1>> getCargos() {
        if (cargos == null) {
            return Optional.empty();
        }
        return cargos;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_company_name")
    private Optional<String> _getForwarderOrgCompanyName() {
        return forwarderOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_handle")
    private Optional<String> _getForwarderOrgHandle() {
        return forwarderOrgHandle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_company_name")
    private Optional<String> _getShipperOrgCompanyName() {
        return shipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_company_name")
    private Optional<String> _getOffChrtShipperOrgCompanyName() {
        return offChrtShipperOrgCompanyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("task_groups_expanded")
    private Optional<List<TaskGroupExpanded>> _getTaskGroupsExpanded() {
        return taskGroupsExpanded;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargos")
    private Optional<List<Cargo1>> _getCargos() {
        return cargos;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftExpanded && equalTo((OrderDraftExpanded) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftExpanded other) {
        return order.equals(other.order)
                && forwarderOrgCompanyName.equals(other.forwarderOrgCompanyName)
                && forwarderOrgHandle.equals(other.forwarderOrgHandle)
                && shipperOrgCompanyName.equals(other.shipperOrgCompanyName)
                && offChrtShipperOrgCompanyName.equals(other.offChrtShipperOrgCompanyName)
                && taskGroupsExpanded.equals(other.taskGroupsExpanded)
                && cargos.equals(other.cargos);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.order,
                this.forwarderOrgCompanyName,
                this.forwarderOrgHandle,
                this.shipperOrgCompanyName,
                this.offChrtShipperOrgCompanyName,
                this.taskGroupsExpanded,
                this.cargos);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderStage builder() {
        return new Builder();
    }

    public interface OrderStage {
        _FinalStage order(@NotNull Order1 order);

        Builder from(OrderDraftExpanded other);
    }

    public interface _FinalStage {
        OrderDraftExpanded build();

        _FinalStage forwarderOrgCompanyName(Optional<String> forwarderOrgCompanyName);

        _FinalStage forwarderOrgCompanyName(String forwarderOrgCompanyName);

        _FinalStage forwarderOrgCompanyName(Nullable<String> forwarderOrgCompanyName);

        _FinalStage forwarderOrgHandle(Optional<String> forwarderOrgHandle);

        _FinalStage forwarderOrgHandle(String forwarderOrgHandle);

        _FinalStage forwarderOrgHandle(Nullable<String> forwarderOrgHandle);

        _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName);

        _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName);

        _FinalStage offChrtShipperOrgCompanyName(Optional<String> offChrtShipperOrgCompanyName);

        _FinalStage offChrtShipperOrgCompanyName(String offChrtShipperOrgCompanyName);

        _FinalStage offChrtShipperOrgCompanyName(Nullable<String> offChrtShipperOrgCompanyName);

        _FinalStage taskGroupsExpanded(Optional<List<TaskGroupExpanded>> taskGroupsExpanded);

        _FinalStage taskGroupsExpanded(List<TaskGroupExpanded> taskGroupsExpanded);

        _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupExpanded>> taskGroupsExpanded);

        _FinalStage cargos(Optional<List<Cargo1>> cargos);

        _FinalStage cargos(List<Cargo1> cargos);

        _FinalStage cargos(Nullable<List<Cargo1>> cargos);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderStage, _FinalStage {
        private Order1 order;

        private Optional<List<Cargo1>> cargos = Optional.empty();

        private Optional<List<TaskGroupExpanded>> taskGroupsExpanded = Optional.empty();

        private Optional<String> offChrtShipperOrgCompanyName = Optional.empty();

        private Optional<String> shipperOrgCompanyName = Optional.empty();

        private Optional<String> forwarderOrgHandle = Optional.empty();

        private Optional<String> forwarderOrgCompanyName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftExpanded other) {
            order(other.getOrder());
            forwarderOrgCompanyName(other.getForwarderOrgCompanyName());
            forwarderOrgHandle(other.getForwarderOrgHandle());
            shipperOrgCompanyName(other.getShipperOrgCompanyName());
            offChrtShipperOrgCompanyName(other.getOffChrtShipperOrgCompanyName());
            taskGroupsExpanded(other.getTaskGroupsExpanded());
            cargos(other.getCargos());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order")
        public _FinalStage order(@NotNull Order1 order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(Nullable<List<Cargo1>> cargos) {
            if (cargos.isNull()) {
                this.cargos = null;
            } else if (cargos.isEmpty()) {
                this.cargos = Optional.empty();
            } else {
                this.cargos = Optional.of(cargos.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargos(List<Cargo1> cargos) {
            this.cargos = Optional.ofNullable(cargos);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargos", nulls = Nulls.SKIP)
        public _FinalStage cargos(Optional<List<Cargo1>> cargos) {
            this.cargos = cargos;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupExpanded>> taskGroupsExpanded) {
            if (taskGroupsExpanded.isNull()) {
                this.taskGroupsExpanded = null;
            } else if (taskGroupsExpanded.isEmpty()) {
                this.taskGroupsExpanded = Optional.empty();
            } else {
                this.taskGroupsExpanded = Optional.of(taskGroupsExpanded.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupsExpanded(List<TaskGroupExpanded> taskGroupsExpanded) {
            this.taskGroupsExpanded = Optional.ofNullable(taskGroupsExpanded);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_groups_expanded", nulls = Nulls.SKIP)
        public _FinalStage taskGroupsExpanded(Optional<List<TaskGroupExpanded>> taskGroupsExpanded) {
            this.taskGroupsExpanded = taskGroupsExpanded;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgCompanyName(Nullable<String> offChrtShipperOrgCompanyName) {
            if (offChrtShipperOrgCompanyName.isNull()) {
                this.offChrtShipperOrgCompanyName = null;
            } else if (offChrtShipperOrgCompanyName.isEmpty()) {
                this.offChrtShipperOrgCompanyName = Optional.empty();
            } else {
                this.offChrtShipperOrgCompanyName = Optional.of(offChrtShipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgCompanyName(String offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = Optional.ofNullable(offChrtShipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgCompanyName(Optional<String> offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName) {
            if (shipperOrgCompanyName.isNull()) {
                this.shipperOrgCompanyName = null;
            } else if (shipperOrgCompanyName.isEmpty()) {
                this.shipperOrgCompanyName = Optional.empty();
            } else {
                this.shipperOrgCompanyName = Optional.of(shipperOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName) {
            this.shipperOrgCompanyName = Optional.ofNullable(shipperOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgHandle(Nullable<String> forwarderOrgHandle) {
            if (forwarderOrgHandle.isNull()) {
                this.forwarderOrgHandle = null;
            } else if (forwarderOrgHandle.isEmpty()) {
                this.forwarderOrgHandle = Optional.empty();
            } else {
                this.forwarderOrgHandle = Optional.of(forwarderOrgHandle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgHandle(String forwarderOrgHandle) {
            this.forwarderOrgHandle = Optional.ofNullable(forwarderOrgHandle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_org_handle", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgHandle(Optional<String> forwarderOrgHandle) {
            this.forwarderOrgHandle = forwarderOrgHandle;
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgCompanyName(Nullable<String> forwarderOrgCompanyName) {
            if (forwarderOrgCompanyName.isNull()) {
                this.forwarderOrgCompanyName = null;
            } else if (forwarderOrgCompanyName.isEmpty()) {
                this.forwarderOrgCompanyName = Optional.empty();
            } else {
                this.forwarderOrgCompanyName = Optional.of(forwarderOrgCompanyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderOrgCompanyName(String forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = Optional.ofNullable(forwarderOrgCompanyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_org_company_name", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgCompanyName(Optional<String> forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = forwarderOrgCompanyName;
            return this;
        }

        @java.lang.Override
        public OrderDraftExpanded build() {
            return new OrderDraftExpanded(
                    order,
                    forwarderOrgCompanyName,
                    forwarderOrgHandle,
                    shipperOrgCompanyName,
                    offChrtShipperOrgCompanyName,
                    taskGroupsExpanded,
                    cargos,
                    additionalProperties);
        }
    }
}
