/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrgMemberDetails.Builder.class)
public final class OrgMemberDetails {
    private final OrgRoleEnum role;

    private final String userId;

    private final Optional<String> firstName;

    private final Optional<String> lastName;

    private final Map<String, Object> additionalProperties;

    private OrgMemberDetails(
            OrgRoleEnum role,
            String userId,
            Optional<String> firstName,
            Optional<String> lastName,
            Map<String, Object> additionalProperties) {
        this.role = role;
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("role")
    public OrgRoleEnum getRole() {
        return role;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (firstName == null) {
            return Optional.empty();
        }
        return firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (lastName == null) {
            return Optional.empty();
        }
        return lastName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("first_name")
    private Optional<String> _getFirstName() {
        return firstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_name")
    private Optional<String> _getLastName() {
        return lastName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrgMemberDetails && equalTo((OrgMemberDetails) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgMemberDetails other) {
        return role.equals(other.role)
                && userId.equals(other.userId)
                && firstName.equals(other.firstName)
                && lastName.equals(other.lastName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.role, this.userId, this.firstName, this.lastName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RoleStage builder() {
        return new Builder();
    }

    public interface RoleStage {
        UserIdStage role(@NotNull OrgRoleEnum role);

        Builder from(OrgMemberDetails other);
    }

    public interface UserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage userId(@NotNull String userId);
    }

    public interface _FinalStage {
        OrgMemberDetails build();

        _FinalStage firstName(Optional<String> firstName);

        _FinalStage firstName(String firstName);

        _FinalStage firstName(Nullable<String> firstName);

        _FinalStage lastName(Optional<String> lastName);

        _FinalStage lastName(String lastName);

        _FinalStage lastName(Nullable<String> lastName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RoleStage, UserIdStage, _FinalStage {
        private OrgRoleEnum role;

        private String userId;

        private Optional<String> lastName = Optional.empty();

        private Optional<String> firstName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrgMemberDetails other) {
            role(other.getRole());
            userId(other.getUserId());
            firstName(other.getFirstName());
            lastName(other.getLastName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("role")
        public UserIdStage role(@NotNull OrgRoleEnum role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(Nullable<String> lastName) {
            if (lastName.isNull()) {
                this.lastName = null;
            } else if (lastName.isEmpty()) {
                this.lastName = Optional.empty();
            } else {
                this.lastName = Optional.of(lastName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_name", nulls = Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(Nullable<String> firstName) {
            if (firstName.isNull()) {
                this.firstName = null;
            } else if (firstName.isEmpty()) {
                this.firstName = Optional.empty();
            } else {
                this.firstName = Optional.of(firstName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "first_name", nulls = Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @java.lang.Override
        public OrgMemberDetails build() {
            return new OrgMemberDetails(role, userId, firstName, lastName, additionalProperties);
        }
    }
}
