/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrgPublicData1.Builder.class)
public final class OrgPublicData1 {
    private final int schemaVersion;

    private final OrgTypeEnum orgType;

    private final String orgId;

    private final Optional<String> companyName;

    private final Optional<String> handle;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private OrgPublicData1(
            int schemaVersion,
            OrgTypeEnum orgType,
            String orgId,
            Optional<String> companyName,
            Optional<String> handle,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.orgType = orgType;
        this.orgId = orgId;
        this.companyName = companyName;
        this.handle = handle;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("org_type")
    public OrgTypeEnum getOrgType() {
        return orgType;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (companyName == null) {
            return Optional.empty();
        }
        return companyName;
    }

    @JsonIgnore
    public Optional<String> getHandle() {
        if (handle == null) {
            return Optional.empty();
        }
        return handle;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("company_name")
    private Optional<String> _getCompanyName() {
        return companyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("handle")
    private Optional<String> _getHandle() {
        return handle;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrgPublicData1 && equalTo((OrgPublicData1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgPublicData1 other) {
        return schemaVersion == other.schemaVersion
                && orgType.equals(other.orgType)
                && orgId.equals(other.orgId)
                && companyName.equals(other.companyName)
                && handle.equals(other.handle)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.orgType, this.orgId, this.companyName, this.handle, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        OrgTypeStage schemaVersion(int schemaVersion);

        Builder from(OrgPublicData1 other);
    }

    public interface OrgTypeStage {
        OrgIdStage orgType(@NotNull OrgTypeEnum orgType);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        IdStage orgId(@NotNull String orgId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        OrgPublicData1 build();

        _FinalStage companyName(Optional<String> companyName);

        _FinalStage companyName(String companyName);

        _FinalStage companyName(Nullable<String> companyName);

        _FinalStage handle(Optional<String> handle);

        _FinalStage handle(String handle);

        _FinalStage handle(Nullable<String> handle);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, OrgTypeStage, OrgIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private OrgTypeEnum orgType;

        private String orgId;

        private String id;

        private Optional<String> handle = Optional.empty();

        private Optional<String> companyName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrgPublicData1 other) {
            schemaVersion(other.getSchemaVersion());
            orgType(other.getOrgType());
            orgId(other.getOrgId());
            companyName(other.getCompanyName());
            handle(other.getHandle());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public OrgTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("org_type")
        public OrgIdStage orgType(@NotNull OrgTypeEnum orgType) {
            this.orgType = Objects.requireNonNull(orgType, "orgType must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public IdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage handle(Nullable<String> handle) {
            if (handle.isNull()) {
                this.handle = null;
            } else if (handle.isEmpty()) {
                this.handle = Optional.empty();
            } else {
                this.handle = Optional.of(handle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage handle(String handle) {
            this.handle = Optional.ofNullable(handle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "handle", nulls = Nulls.SKIP)
        public _FinalStage handle(Optional<String> handle) {
            this.handle = handle;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(Nullable<String> companyName) {
            if (companyName.isNull()) {
                this.companyName = null;
            } else if (companyName.isEmpty()) {
                this.companyName = Optional.empty();
            } else {
                this.companyName = Optional.of(companyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_name", nulls = Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @java.lang.Override
        public OrgPublicData1 build() {
            return new OrgPublicData1(schemaVersion, orgType, orgId, companyName, handle, id, additionalProperties);
        }
    }
}
