/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Point.Builder.class)
public final class Point {
    private final Optional<List<Object>> bbox;

    private final Coordinates coordinates;

    private final Map<String, Object> additionalProperties;

    private Point(Optional<List<Object>> bbox, Coordinates coordinates, Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.coordinates = coordinates;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (bbox == null) {
            return Optional.empty();
        }
        return bbox;
    }

    @JsonProperty("coordinates")
    public Coordinates getCoordinates() {
        return coordinates;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("bbox")
    private Optional<List<Object>> _getBbox() {
        return bbox;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Point && equalTo((Point) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Point other) {
        return bbox.equals(other.bbox) && coordinates.equals(other.coordinates);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.bbox, this.coordinates);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CoordinatesStage builder() {
        return new Builder();
    }

    public interface CoordinatesStage {
        _FinalStage coordinates(@NotNull Coordinates coordinates);

        Builder from(Point other);
    }

    public interface _FinalStage {
        Point build();

        _FinalStage bbox(Optional<List<Object>> bbox);

        _FinalStage bbox(List<Object> bbox);

        _FinalStage bbox(Nullable<List<Object>> bbox);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CoordinatesStage, _FinalStage {
        private Coordinates coordinates;

        private Optional<List<Object>> bbox = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Point other) {
            bbox(other.getBbox());
            coordinates(other.getCoordinates());
            return this;
        }

        @java.lang.Override
        @JsonSetter("coordinates")
        public _FinalStage coordinates(@NotNull Coordinates coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates, "coordinates must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage bbox(Nullable<List<Object>> bbox) {
            if (bbox.isNull()) {
                this.bbox = null;
            } else if (bbox.isEmpty()) {
                this.bbox = Optional.empty();
            } else {
                this.bbox = Optional.of(bbox.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "bbox", nulls = Nulls.SKIP)
        public _FinalStage bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        @java.lang.Override
        public Point build() {
            return new Point(bbox, coordinates, additionalProperties);
        }
    }
}
