/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RateSheetListResponse.Builder.class)
public final class RateSheetListResponse {
    private final List<RateSheet1> rateSheets;

    private final int totalCount;

    private final Map<String, Object> additionalProperties;

    private RateSheetListResponse(
            List<RateSheet1> rateSheets, int totalCount, Map<String, Object> additionalProperties) {
        this.rateSheets = rateSheets;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("rate_sheets")
    public List<RateSheet1> getRateSheets() {
        return rateSheets;
    }

    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RateSheetListResponse && equalTo((RateSheetListResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetListResponse other) {
        return rateSheets.equals(other.rateSheets) && totalCount == other.totalCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rateSheets, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        _FinalStage totalCount(int totalCount);

        Builder from(RateSheetListResponse other);
    }

    public interface _FinalStage {
        RateSheetListResponse build();

        _FinalStage rateSheets(List<RateSheet1> rateSheets);

        _FinalStage addRateSheets(RateSheet1 rateSheets);

        _FinalStage addAllRateSheets(List<RateSheet1> rateSheets);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<RateSheet1> rateSheets = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RateSheetListResponse other) {
            rateSheets(other.getRateSheets());
            totalCount(other.getTotalCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllRateSheets(List<RateSheet1> rateSheets) {
            if (rateSheets != null) {
                this.rateSheets.addAll(rateSheets);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addRateSheets(RateSheet1 rateSheets) {
            this.rateSheets.add(rateSheets);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rate_sheets", nulls = Nulls.SKIP)
        public _FinalStage rateSheets(List<RateSheet1> rateSheets) {
            this.rateSheets.clear();
            if (rateSheets != null) {
                this.rateSheets.addAll(rateSheets);
            }
            return this;
        }

        @java.lang.Override
        public RateSheetListResponse build() {
            return new RateSheetListResponse(rateSheets, totalCount, additionalProperties);
        }
    }
}
