/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperContact1.Builder.class)
public final class ShipperContact1 {
    private final int schemaVersion;

    private final Optional<String> shipperOrgId;

    private final Optional<String> shipperUserId;

    private final Optional<String> offChrtShipperOrgId;

    private final Optional<String> companyName;

    private final Optional<String> industry;

    private final Optional<LocationFeature> streetAddress;

    private final Optional<String> contactFirstName;

    private final Optional<String> contactLastName;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> jobTitle;

    private final Optional<String> notes;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ShipperContact1(
            int schemaVersion,
            Optional<String> shipperOrgId,
            Optional<String> shipperUserId,
            Optional<String> offChrtShipperOrgId,
            Optional<String> companyName,
            Optional<String> industry,
            Optional<LocationFeature> streetAddress,
            Optional<String> contactFirstName,
            Optional<String> contactLastName,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            Optional<String> emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> jobTitle,
            Optional<String> notes,
            String createdByOrgId,
            String createdByUserId,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperOrgId = shipperOrgId;
        this.shipperUserId = shipperUserId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.companyName = companyName;
        this.industry = industry;
        this.streetAddress = streetAddress;
        this.contactFirstName = contactFirstName;
        this.contactLastName = contactLastName;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.jobTitle = jobTitle;
        this.notes = notes;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperUserId() {
        if (shipperUserId == null) {
            return Optional.empty();
        }
        return shipperUserId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (companyName == null) {
            return Optional.empty();
        }
        return companyName;
    }

    @JsonIgnore
    public Optional<String> getIndustry() {
        if (industry == null) {
            return Optional.empty();
        }
        return industry;
    }

    @JsonIgnore
    public Optional<LocationFeature> getStreetAddress() {
        if (streetAddress == null) {
            return Optional.empty();
        }
        return streetAddress;
    }

    @JsonIgnore
    public Optional<String> getContactFirstName() {
        if (contactFirstName == null) {
            return Optional.empty();
        }
        return contactFirstName;
    }

    @JsonIgnore
    public Optional<String> getContactLastName() {
        if (contactLastName == null) {
            return Optional.empty();
        }
        return contactLastName;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getJobTitle() {
        if (jobTitle == null) {
            return Optional.empty();
        }
        return jobTitle;
    }

    @JsonIgnore
    public Optional<String> getNotes() {
        if (notes == null) {
            return Optional.empty();
        }
        return notes;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_user_id")
    private Optional<String> _getShipperUserId() {
        return shipperUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("company_name")
    private Optional<String> _getCompanyName() {
        return companyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("industry")
    private Optional<String> _getIndustry() {
        return industry;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("street_address")
    private Optional<LocationFeature> _getStreetAddress() {
        return streetAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_first_name")
    private Optional<String> _getContactFirstName() {
        return contactFirstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_last_name")
    private Optional<String> _getContactLastName() {
        return contactLastName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("job_title")
    private Optional<String> _getJobTitle() {
        return jobTitle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("notes")
    private Optional<String> _getNotes() {
        return notes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperContact1 && equalTo((ShipperContact1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperContact1 other) {
        return schemaVersion == other.schemaVersion
                && shipperOrgId.equals(other.shipperOrgId)
                && shipperUserId.equals(other.shipperUserId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId)
                && companyName.equals(other.companyName)
                && industry.equals(other.industry)
                && streetAddress.equals(other.streetAddress)
                && contactFirstName.equals(other.contactFirstName)
                && contactLastName.equals(other.contactLastName)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && jobTitle.equals(other.jobTitle)
                && notes.equals(other.notes)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.shipperOrgId,
                this.shipperUserId,
                this.offChrtShipperOrgId,
                this.companyName,
                this.industry,
                this.streetAddress,
                this.contactFirstName,
                this.contactLastName,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.jobTitle,
                this.notes,
                this.createdByOrgId,
                this.createdByUserId,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        CreatedByOrgIdStage schemaVersion(int schemaVersion);

        Builder from(ShipperContact1 other);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        IdStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ShipperContact1 build();

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage shipperOrgId(Optional<String> shipperOrgId);

        _FinalStage shipperOrgId(String shipperOrgId);

        _FinalStage shipperOrgId(Nullable<String> shipperOrgId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage shipperUserId(Optional<String> shipperUserId);

        _FinalStage shipperUserId(String shipperUserId);

        _FinalStage shipperUserId(Nullable<String> shipperUserId);

        _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId);

        _FinalStage companyName(Optional<String> companyName);

        _FinalStage companyName(String companyName);

        _FinalStage companyName(Nullable<String> companyName);

        _FinalStage industry(Optional<String> industry);

        _FinalStage industry(String industry);

        _FinalStage industry(Nullable<String> industry);

        _FinalStage streetAddress(Optional<LocationFeature> streetAddress);

        _FinalStage streetAddress(LocationFeature streetAddress);

        _FinalStage streetAddress(Nullable<LocationFeature> streetAddress);

        _FinalStage contactFirstName(Optional<String> contactFirstName);

        _FinalStage contactFirstName(String contactFirstName);

        _FinalStage contactFirstName(Nullable<String> contactFirstName);

        _FinalStage contactLastName(Optional<String> contactLastName);

        _FinalStage contactLastName(String contactLastName);

        _FinalStage contactLastName(Nullable<String> contactLastName);

        _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(String phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary);

        _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(String phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary);

        _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary);

        _FinalStage emailAddressPrimary(String emailAddressPrimary);

        _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary);

        _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary);

        _FinalStage emailAddressSecondary(String emailAddressSecondary);

        _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary);

        _FinalStage jobTitle(Optional<String> jobTitle);

        _FinalStage jobTitle(String jobTitle);

        _FinalStage jobTitle(Nullable<String> jobTitle);

        _FinalStage notes(Optional<String> notes);

        _FinalStage notes(String notes);

        _FinalStage notes(Nullable<String> notes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, CreatedByOrgIdStage, CreatedByUserIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String createdByOrgId;

        private String createdByUserId;

        private String id;

        private Optional<String> notes = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> contactLastName = Optional.empty();

        private Optional<String> contactFirstName = Optional.empty();

        private Optional<LocationFeature> streetAddress = Optional.empty();

        private Optional<String> industry = Optional.empty();

        private Optional<String> companyName = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private Optional<String> shipperUserId = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperContact1 other) {
            schemaVersion(other.getSchemaVersion());
            shipperOrgId(other.getShipperOrgId());
            shipperUserId(other.getShipperUserId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            companyName(other.getCompanyName());
            industry(other.getIndustry());
            streetAddress(other.getStreetAddress());
            contactFirstName(other.getContactFirstName());
            contactLastName(other.getContactLastName());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            jobTitle(other.getJobTitle());
            notes(other.getNotes());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public CreatedByOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public IdStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(Nullable<String> notes) {
            if (notes.isNull()) {
                this.notes = null;
            } else if (notes.isEmpty()) {
                this.notes = Optional.empty();
            } else {
                this.notes = Optional.of(notes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(String notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public _FinalStage notes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        @java.lang.Override
        public _FinalStage jobTitle(Nullable<String> jobTitle) {
            if (jobTitle.isNull()) {
                this.jobTitle = null;
            } else if (jobTitle.isEmpty()) {
                this.jobTitle = Optional.empty();
            } else {
                this.jobTitle = Optional.of(jobTitle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "job_title", nulls = Nulls.SKIP)
        public _FinalStage jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage contactLastName(Nullable<String> contactLastName) {
            if (contactLastName.isNull()) {
                this.contactLastName = null;
            } else if (contactLastName.isEmpty()) {
                this.contactLastName = Optional.empty();
            } else {
                this.contactLastName = Optional.of(contactLastName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage contactLastName(String contactLastName) {
            this.contactLastName = Optional.ofNullable(contactLastName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "contact_last_name", nulls = Nulls.SKIP)
        public _FinalStage contactLastName(Optional<String> contactLastName) {
            this.contactLastName = contactLastName;
            return this;
        }

        @java.lang.Override
        public _FinalStage contactFirstName(Nullable<String> contactFirstName) {
            if (contactFirstName.isNull()) {
                this.contactFirstName = null;
            } else if (contactFirstName.isEmpty()) {
                this.contactFirstName = Optional.empty();
            } else {
                this.contactFirstName = Optional.of(contactFirstName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage contactFirstName(String contactFirstName) {
            this.contactFirstName = Optional.ofNullable(contactFirstName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "contact_first_name", nulls = Nulls.SKIP)
        public _FinalStage contactFirstName(Optional<String> contactFirstName) {
            this.contactFirstName = contactFirstName;
            return this;
        }

        @java.lang.Override
        public _FinalStage streetAddress(Nullable<LocationFeature> streetAddress) {
            if (streetAddress.isNull()) {
                this.streetAddress = null;
            } else if (streetAddress.isEmpty()) {
                this.streetAddress = Optional.empty();
            } else {
                this.streetAddress = Optional.of(streetAddress.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage streetAddress(LocationFeature streetAddress) {
            this.streetAddress = Optional.ofNullable(streetAddress);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "street_address", nulls = Nulls.SKIP)
        public _FinalStage streetAddress(Optional<LocationFeature> streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        @java.lang.Override
        public _FinalStage industry(Nullable<String> industry) {
            if (industry.isNull()) {
                this.industry = null;
            } else if (industry.isEmpty()) {
                this.industry = Optional.empty();
            } else {
                this.industry = Optional.of(industry.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "industry", nulls = Nulls.SKIP)
        public _FinalStage industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(Nullable<String> companyName) {
            if (companyName.isNull()) {
                this.companyName = null;
            } else if (companyName.isEmpty()) {
                this.companyName = Optional.empty();
            } else {
                this.companyName = Optional.of(companyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_name", nulls = Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperUserId(Nullable<String> shipperUserId) {
            if (shipperUserId.isNull()) {
                this.shipperUserId = null;
            } else if (shipperUserId.isEmpty()) {
                this.shipperUserId = Optional.empty();
            } else {
                this.shipperUserId = Optional.of(shipperUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperUserId(String shipperUserId) {
            this.shipperUserId = Optional.ofNullable(shipperUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_user_id", nulls = Nulls.SKIP)
        public _FinalStage shipperUserId(Optional<String> shipperUserId) {
            this.shipperUserId = shipperUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @java.lang.Override
        public ShipperContact1 build() {
            return new ShipperContact1(
                    schemaVersion,
                    shipperOrgId,
                    shipperUserId,
                    offChrtShipperOrgId,
                    companyName,
                    industry,
                    streetAddress,
                    contactFirstName,
                    contactLastName,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    jobTitle,
                    notes,
                    createdByOrgId,
                    createdByUserId,
                    id,
                    additionalProperties);
        }
    }
}
