/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperCourierConnection1.Builder.class)
public final class ShipperCourierConnection1 {
    private final int schemaVersion;

    private final String shipperOrgId;

    private final String courierOrgId;

    private final Optional<Boolean> connected;

    private final Optional<String> shipperCustomerIdForCourierStripeConnectAccount;

    private final Optional<String> defaultRateSheetRouted;

    private final Optional<String> defaultRateSheetOnDemand;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ShipperCourierConnection1(
            int schemaVersion,
            String shipperOrgId,
            String courierOrgId,
            Optional<Boolean> connected,
            Optional<String> shipperCustomerIdForCourierStripeConnectAccount,
            Optional<String> defaultRateSheetRouted,
            Optional<String> defaultRateSheetOnDemand,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperOrgId = shipperOrgId;
        this.courierOrgId = courierOrgId;
        this.connected = connected;
        this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
        this.defaultRateSheetRouted = defaultRateSheetRouted;
        this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("shipper_org_id")
    public String getShipperOrgId() {
        return shipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonProperty("connected")
    public Optional<Boolean> getConnected() {
        return connected;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForCourierStripeConnectAccount() {
        if (shipperCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetRouted() {
        if (defaultRateSheetRouted == null) {
            return Optional.empty();
        }
        return defaultRateSheetRouted;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetOnDemand() {
        if (defaultRateSheetOnDemand == null) {
            return Optional.empty();
        }
        return defaultRateSheetOnDemand;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForCourierStripeConnectAccount() {
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("default_rate_sheet__routed")
    private Optional<String> _getDefaultRateSheetRouted() {
        return defaultRateSheetRouted;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("default_rate_sheet__on_demand")
    private Optional<String> _getDefaultRateSheetOnDemand() {
        return defaultRateSheetOnDemand;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperCourierConnection1 && equalTo((ShipperCourierConnection1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperCourierConnection1 other) {
        return schemaVersion == other.schemaVersion
                && shipperOrgId.equals(other.shipperOrgId)
                && courierOrgId.equals(other.courierOrgId)
                && connected.equals(other.connected)
                && shipperCustomerIdForCourierStripeConnectAccount.equals(
                        other.shipperCustomerIdForCourierStripeConnectAccount)
                && defaultRateSheetRouted.equals(other.defaultRateSheetRouted)
                && defaultRateSheetOnDemand.equals(other.defaultRateSheetOnDemand)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.shipperOrgId,
                this.courierOrgId,
                this.connected,
                this.shipperCustomerIdForCourierStripeConnectAccount,
                this.defaultRateSheetRouted,
                this.defaultRateSheetOnDemand,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        ShipperOrgIdStage schemaVersion(int schemaVersion);

        Builder from(ShipperCourierConnection1 other);
    }

    public interface ShipperOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CourierOrgIdStage shipperOrgId(@NotNull String shipperOrgId);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        IdStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ShipperCourierConnection1 build();

        _FinalStage connected(Optional<Boolean> connected);

        _FinalStage connected(Boolean connected);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage defaultRateSheetRouted(Optional<String> defaultRateSheetRouted);

        _FinalStage defaultRateSheetRouted(String defaultRateSheetRouted);

        _FinalStage defaultRateSheetRouted(Nullable<String> defaultRateSheetRouted);

        _FinalStage defaultRateSheetOnDemand(Optional<String> defaultRateSheetOnDemand);

        _FinalStage defaultRateSheetOnDemand(String defaultRateSheetOnDemand);

        _FinalStage defaultRateSheetOnDemand(Nullable<String> defaultRateSheetOnDemand);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, ShipperOrgIdStage, CourierOrgIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String shipperOrgId;

        private String courierOrgId;

        private String id;

        private Optional<String> defaultRateSheetOnDemand = Optional.empty();

        private Optional<String> defaultRateSheetRouted = Optional.empty();

        private Optional<String> shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();

        private Optional<Boolean> connected = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperCourierConnection1 other) {
            schemaVersion(other.getSchemaVersion());
            shipperOrgId(other.getShipperOrgId());
            courierOrgId(other.getCourierOrgId());
            connected(other.getConnected());
            shipperCustomerIdForCourierStripeConnectAccount(other.getShipperCustomerIdForCourierStripeConnectAccount());
            defaultRateSheetRouted(other.getDefaultRateSheetRouted());
            defaultRateSheetOnDemand(other.getDefaultRateSheetOnDemand());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ShipperOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("shipper_org_id")
        public CourierOrgIdStage shipperOrgId(@NotNull String shipperOrgId) {
            this.shipperOrgId = Objects.requireNonNull(shipperOrgId, "shipperOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public IdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultRateSheetOnDemand(Nullable<String> defaultRateSheetOnDemand) {
            if (defaultRateSheetOnDemand.isNull()) {
                this.defaultRateSheetOnDemand = null;
            } else if (defaultRateSheetOnDemand.isEmpty()) {
                this.defaultRateSheetOnDemand = Optional.empty();
            } else {
                this.defaultRateSheetOnDemand = Optional.of(defaultRateSheetOnDemand.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultRateSheetOnDemand(String defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = Optional.ofNullable(defaultRateSheetOnDemand);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_rate_sheet__on_demand", nulls = Nulls.SKIP)
        public _FinalStage defaultRateSheetOnDemand(Optional<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultRateSheetRouted(Nullable<String> defaultRateSheetRouted) {
            if (defaultRateSheetRouted.isNull()) {
                this.defaultRateSheetRouted = null;
            } else if (defaultRateSheetRouted.isEmpty()) {
                this.defaultRateSheetRouted = Optional.empty();
            } else {
                this.defaultRateSheetRouted = Optional.of(defaultRateSheetRouted.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultRateSheetRouted(String defaultRateSheetRouted) {
            this.defaultRateSheetRouted = Optional.ofNullable(defaultRateSheetRouted);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_rate_sheet__routed", nulls = Nulls.SKIP)
        public _FinalStage defaultRateSheetRouted(Optional<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount) {
            if (shipperCustomerIdForCourierStripeConnectAccount.isNull()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = null;
            } else if (shipperCustomerIdForCourierStripeConnectAccount.isEmpty()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();
            } else {
                this.shipperCustomerIdForCourierStripeConnectAccount =
                        Optional.of(shipperCustomerIdForCourierStripeConnectAccount.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount =
                    Optional.ofNullable(shipperCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_customer_id_for_courier_stripe_connect_account", nulls = Nulls.SKIP)
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @java.lang.Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "connected", nulls = Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @java.lang.Override
        public ShipperCourierConnection1 build() {
            return new ShipperCourierConnection1(
                    schemaVersion,
                    shipperOrgId,
                    courierOrgId,
                    connected,
                    shipperCustomerIdForCourierStripeConnectAccount,
                    defaultRateSheetRouted,
                    defaultRateSheetOnDemand,
                    id,
                    additionalProperties);
        }
    }
}
