/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Statement1.Builder.class)
public final class Statement1 {
    private final int schemaVersion;

    private final String id;

    private final Optional<List<String>> lineItemGroupIds;

    private final int amount;

    private final Optional<UnitsEnum> units;

    private final Optional<String> stagedByUserId;

    private final SettlementTypeEnum1 settlementType;

    private final String ownedByOrgId;

    private final PaymentVectorTypeEnum1 paymentVectorType;

    private final Optional<String> paymentOriginOrgId;

    private final Optional<String> paymentOriginOffChrtShipperOrgId;

    private final Optional<String> paymentDestinationOrgId;

    private final Optional<String> paymentDestinationDriverId;

    private final Optional<StatementStatusEnum1> status;

    private final Optional<String> stripeInvoiceId;

    private final Optional<String> stripeInvoiceUrl;

    private final Optional<String> stripeInvoiceCreatedByUserId;

    private final Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> openedAtTimestamp;

    private final Optional<OffsetDateTime> paidAtTimestamp;

    private final Optional<OffsetDateTime> uncollectibleAtTimestamp;

    private final Optional<String> markedOpenByUserId;

    private final Optional<String> markedPaidByUserId;

    private final Optional<String> markedUncollectibleByUserId;

    private final Map<String, Object> additionalProperties;

    private Statement1(
            int schemaVersion,
            String id,
            Optional<List<String>> lineItemGroupIds,
            int amount,
            Optional<UnitsEnum> units,
            Optional<String> stagedByUserId,
            SettlementTypeEnum1 settlementType,
            String ownedByOrgId,
            PaymentVectorTypeEnum1 paymentVectorType,
            Optional<String> paymentOriginOrgId,
            Optional<String> paymentOriginOffChrtShipperOrgId,
            Optional<String> paymentDestinationOrgId,
            Optional<String> paymentDestinationDriverId,
            Optional<StatementStatusEnum1> status,
            Optional<String> stripeInvoiceId,
            Optional<String> stripeInvoiceUrl,
            Optional<String> stripeInvoiceCreatedByUserId,
            Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> openedAtTimestamp,
            Optional<OffsetDateTime> paidAtTimestamp,
            Optional<OffsetDateTime> uncollectibleAtTimestamp,
            Optional<String> markedOpenByUserId,
            Optional<String> markedPaidByUserId,
            Optional<String> markedUncollectibleByUserId,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.lineItemGroupIds = lineItemGroupIds;
        this.amount = amount;
        this.units = units;
        this.stagedByUserId = stagedByUserId;
        this.settlementType = settlementType;
        this.ownedByOrgId = ownedByOrgId;
        this.paymentVectorType = paymentVectorType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.status = status;
        this.stripeInvoiceId = stripeInvoiceId;
        this.stripeInvoiceUrl = stripeInvoiceUrl;
        this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
        this.stripeInvoiceStatus = stripeInvoiceStatus;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.openedAtTimestamp = openedAtTimestamp;
        this.paidAtTimestamp = paidAtTimestamp;
        this.uncollectibleAtTimestamp = uncollectibleAtTimestamp;
        this.markedOpenByUserId = markedOpenByUserId;
        this.markedPaidByUserId = markedPaidByUserId;
        this.markedUncollectibleByUserId = markedUncollectibleByUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("line_item_group_ids")
    public Optional<List<String>> getLineItemGroupIds() {
        return lineItemGroupIds;
    }

    @JsonProperty("amount")
    public int getAmount() {
        return amount;
    }

    @JsonProperty("units")
    public Optional<UnitsEnum> getUnits() {
        return units;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getStagedByUserId() {
        if (stagedByUserId == null) {
            return Optional.empty();
        }
        return stagedByUserId;
    }

    @JsonProperty("settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return settlementType;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("owned_by_org_id")
    public String getOwnedByOrgId() {
        return ownedByOrgId;
    }

    @JsonProperty("payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return paymentVectorType;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return paymentOriginOffChrtShipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return paymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return paymentDestinationDriverId;
    }

    @JsonProperty("status")
    public Optional<StatementStatusEnum1> getStatus() {
        return status;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceId() {
        if (stripeInvoiceId == null) {
            return Optional.empty();
        }
        return stripeInvoiceId;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceUrl() {
        if (stripeInvoiceUrl == null) {
            return Optional.empty();
        }
        return stripeInvoiceUrl;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getStripeInvoiceCreatedByUserId() {
        if (stripeInvoiceCreatedByUserId == null) {
            return Optional.empty();
        }
        return stripeInvoiceCreatedByUserId;
    }

    @JsonIgnore
    public Optional<StripeConnectInvoiceStatusEnum> getStripeInvoiceStatus() {
        if (stripeInvoiceStatus == null) {
            return Optional.empty();
        }
        return stripeInvoiceStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getOpenedAtTimestamp() {
        if (openedAtTimestamp == null) {
            return Optional.empty();
        }
        return openedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getPaidAtTimestamp() {
        if (paidAtTimestamp == null) {
            return Optional.empty();
        }
        return paidAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getUncollectibleAtTimestamp() {
        if (uncollectibleAtTimestamp == null) {
            return Optional.empty();
        }
        return uncollectibleAtTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getMarkedOpenByUserId() {
        if (markedOpenByUserId == null) {
            return Optional.empty();
        }
        return markedOpenByUserId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getMarkedPaidByUserId() {
        if (markedPaidByUserId == null) {
            return Optional.empty();
        }
        return markedPaidByUserId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getMarkedUncollectibleByUserId() {
        if (markedUncollectibleByUserId == null) {
            return Optional.empty();
        }
        return markedUncollectibleByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_by_user_id")
    private Optional<String> _getStagedByUserId() {
        return stagedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return paymentOriginOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return paymentDestinationOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return paymentDestinationDriverId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_id")
    private Optional<String> _getStripeInvoiceId() {
        return stripeInvoiceId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_url")
    private Optional<String> _getStripeInvoiceUrl() {
        return stripeInvoiceUrl;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_created_by_user_id")
    private Optional<String> _getStripeInvoiceCreatedByUserId() {
        return stripeInvoiceCreatedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_status")
    private Optional<StripeConnectInvoiceStatusEnum> _getStripeInvoiceStatus() {
        return stripeInvoiceStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("opened_at_timestamp")
    private Optional<OffsetDateTime> _getOpenedAtTimestamp() {
        return openedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("paid_at_timestamp")
    private Optional<OffsetDateTime> _getPaidAtTimestamp() {
        return paidAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("uncollectible_at_timestamp")
    private Optional<OffsetDateTime> _getUncollectibleAtTimestamp() {
        return uncollectibleAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("marked_open_by_user_id")
    private Optional<String> _getMarkedOpenByUserId() {
        return markedOpenByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("marked_paid_by_user_id")
    private Optional<String> _getMarkedPaidByUserId() {
        return markedPaidByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("marked_uncollectible_by_user_id")
    private Optional<String> _getMarkedUncollectibleByUserId() {
        return markedUncollectibleByUserId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Statement1 && equalTo((Statement1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Statement1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && lineItemGroupIds.equals(other.lineItemGroupIds)
                && amount == other.amount
                && units.equals(other.units)
                && stagedByUserId.equals(other.stagedByUserId)
                && settlementType.equals(other.settlementType)
                && ownedByOrgId.equals(other.ownedByOrgId)
                && paymentVectorType.equals(other.paymentVectorType)
                && paymentOriginOrgId.equals(other.paymentOriginOrgId)
                && paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId)
                && paymentDestinationOrgId.equals(other.paymentDestinationOrgId)
                && paymentDestinationDriverId.equals(other.paymentDestinationDriverId)
                && status.equals(other.status)
                && stripeInvoiceId.equals(other.stripeInvoiceId)
                && stripeInvoiceUrl.equals(other.stripeInvoiceUrl)
                && stripeInvoiceCreatedByUserId.equals(other.stripeInvoiceCreatedByUserId)
                && stripeInvoiceStatus.equals(other.stripeInvoiceStatus)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && openedAtTimestamp.equals(other.openedAtTimestamp)
                && paidAtTimestamp.equals(other.paidAtTimestamp)
                && uncollectibleAtTimestamp.equals(other.uncollectibleAtTimestamp)
                && markedOpenByUserId.equals(other.markedOpenByUserId)
                && markedPaidByUserId.equals(other.markedPaidByUserId)
                && markedUncollectibleByUserId.equals(other.markedUncollectibleByUserId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.lineItemGroupIds,
                this.amount,
                this.units,
                this.stagedByUserId,
                this.settlementType,
                this.ownedByOrgId,
                this.paymentVectorType,
                this.paymentOriginOrgId,
                this.paymentOriginOffChrtShipperOrgId,
                this.paymentDestinationOrgId,
                this.paymentDestinationDriverId,
                this.status,
                this.stripeInvoiceId,
                this.stripeInvoiceUrl,
                this.stripeInvoiceCreatedByUserId,
                this.stripeInvoiceStatus,
                this.stagedAtTimestamp,
                this.openedAtTimestamp,
                this.paidAtTimestamp,
                this.uncollectibleAtTimestamp,
                this.markedOpenByUserId,
                this.markedPaidByUserId,
                this.markedUncollectibleByUserId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(Statement1 other);
    }

    public interface IdStage {
        AmountStage id(@NotNull String id);
    }

    public interface AmountStage {
        SettlementTypeStage amount(int amount);
    }

    public interface SettlementTypeStage {
        OwnedByOrgIdStage settlementType(@NotNull SettlementTypeEnum1 settlementType);
    }

    public interface OwnedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId);
    }

    public interface PaymentVectorTypeStage {
        _FinalStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType);
    }

    public interface _FinalStage {
        Statement1 build();

        _FinalStage lineItemGroupIds(Optional<List<String>> lineItemGroupIds);

        _FinalStage lineItemGroupIds(List<String> lineItemGroupIds);

        _FinalStage units(Optional<UnitsEnum> units);

        _FinalStage units(UnitsEnum units);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage stagedByUserId(Optional<String> stagedByUserId);

        _FinalStage stagedByUserId(String stagedByUserId);

        _FinalStage stagedByUserId(Nullable<String> stagedByUserId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(String paymentOriginOrgId);

        _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId);

        _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId);

        _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId);

        _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId);

        _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId);

        _FinalStage status(Optional<StatementStatusEnum1> status);

        _FinalStage status(StatementStatusEnum1 status);

        _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId);

        _FinalStage stripeInvoiceId(String stripeInvoiceId);

        _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId);

        _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl);

        _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl);

        _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus);

        _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus);

        _FinalStage stripeInvoiceStatus(Nullable<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage openedAtTimestamp(Optional<OffsetDateTime> openedAtTimestamp);

        _FinalStage openedAtTimestamp(OffsetDateTime openedAtTimestamp);

        _FinalStage openedAtTimestamp(Nullable<OffsetDateTime> openedAtTimestamp);

        _FinalStage paidAtTimestamp(Optional<OffsetDateTime> paidAtTimestamp);

        _FinalStage paidAtTimestamp(OffsetDateTime paidAtTimestamp);

        _FinalStage paidAtTimestamp(Nullable<OffsetDateTime> paidAtTimestamp);

        _FinalStage uncollectibleAtTimestamp(Optional<OffsetDateTime> uncollectibleAtTimestamp);

        _FinalStage uncollectibleAtTimestamp(OffsetDateTime uncollectibleAtTimestamp);

        _FinalStage uncollectibleAtTimestamp(Nullable<OffsetDateTime> uncollectibleAtTimestamp);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage markedOpenByUserId(Optional<String> markedOpenByUserId);

        _FinalStage markedOpenByUserId(String markedOpenByUserId);

        _FinalStage markedOpenByUserId(Nullable<String> markedOpenByUserId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage markedPaidByUserId(Optional<String> markedPaidByUserId);

        _FinalStage markedPaidByUserId(String markedPaidByUserId);

        _FinalStage markedPaidByUserId(Nullable<String> markedPaidByUserId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage markedUncollectibleByUserId(Optional<String> markedUncollectibleByUserId);

        _FinalStage markedUncollectibleByUserId(String markedUncollectibleByUserId);

        _FinalStage markedUncollectibleByUserId(Nullable<String> markedUncollectibleByUserId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    AmountStage,
                    SettlementTypeStage,
                    OwnedByOrgIdStage,
                    PaymentVectorTypeStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private int amount;

        private SettlementTypeEnum1 settlementType;

        private String ownedByOrgId;

        private PaymentVectorTypeEnum1 paymentVectorType;

        private Optional<String> markedUncollectibleByUserId = Optional.empty();

        private Optional<String> markedPaidByUserId = Optional.empty();

        private Optional<String> markedOpenByUserId = Optional.empty();

        private Optional<OffsetDateTime> uncollectibleAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> paidAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> openedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus = Optional.empty();

        private Optional<String> stripeInvoiceCreatedByUserId = Optional.empty();

        private Optional<String> stripeInvoiceUrl = Optional.empty();

        private Optional<String> stripeInvoiceId = Optional.empty();

        private Optional<StatementStatusEnum1> status = Optional.empty();

        private Optional<String> paymentDestinationDriverId = Optional.empty();

        private Optional<String> paymentDestinationOrgId = Optional.empty();

        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();

        private Optional<String> paymentOriginOrgId = Optional.empty();

        private Optional<String> stagedByUserId = Optional.empty();

        private Optional<UnitsEnum> units = Optional.empty();

        private Optional<List<String>> lineItemGroupIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Statement1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            lineItemGroupIds(other.getLineItemGroupIds());
            amount(other.getAmount());
            units(other.getUnits());
            stagedByUserId(other.getStagedByUserId());
            settlementType(other.getSettlementType());
            ownedByOrgId(other.getOwnedByOrgId());
            paymentVectorType(other.getPaymentVectorType());
            paymentOriginOrgId(other.getPaymentOriginOrgId());
            paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            status(other.getStatus());
            stripeInvoiceId(other.getStripeInvoiceId());
            stripeInvoiceUrl(other.getStripeInvoiceUrl());
            stripeInvoiceCreatedByUserId(other.getStripeInvoiceCreatedByUserId());
            stripeInvoiceStatus(other.getStripeInvoiceStatus());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            openedAtTimestamp(other.getOpenedAtTimestamp());
            paidAtTimestamp(other.getPaidAtTimestamp());
            uncollectibleAtTimestamp(other.getUncollectibleAtTimestamp());
            markedOpenByUserId(other.getMarkedOpenByUserId());
            markedPaidByUserId(other.getMarkedPaidByUserId());
            markedUncollectibleByUserId(other.getMarkedUncollectibleByUserId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public AmountStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount")
        public SettlementTypeStage amount(int amount) {
            this.amount = amount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("settlement_type")
        public OwnedByOrgIdStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("owned_by_org_id")
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId) {
            this.ownedByOrgId = Objects.requireNonNull(ownedByOrgId, "ownedByOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("payment_vector_type")
        public _FinalStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedUncollectibleByUserId(Nullable<String> markedUncollectibleByUserId) {
            if (markedUncollectibleByUserId.isNull()) {
                this.markedUncollectibleByUserId = null;
            } else if (markedUncollectibleByUserId.isEmpty()) {
                this.markedUncollectibleByUserId = Optional.empty();
            } else {
                this.markedUncollectibleByUserId = Optional.of(markedUncollectibleByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedUncollectibleByUserId(String markedUncollectibleByUserId) {
            this.markedUncollectibleByUserId = Optional.ofNullable(markedUncollectibleByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "marked_uncollectible_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage markedUncollectibleByUserId(Optional<String> markedUncollectibleByUserId) {
            this.markedUncollectibleByUserId = markedUncollectibleByUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedPaidByUserId(Nullable<String> markedPaidByUserId) {
            if (markedPaidByUserId.isNull()) {
                this.markedPaidByUserId = null;
            } else if (markedPaidByUserId.isEmpty()) {
                this.markedPaidByUserId = Optional.empty();
            } else {
                this.markedPaidByUserId = Optional.of(markedPaidByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedPaidByUserId(String markedPaidByUserId) {
            this.markedPaidByUserId = Optional.ofNullable(markedPaidByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "marked_paid_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage markedPaidByUserId(Optional<String> markedPaidByUserId) {
            this.markedPaidByUserId = markedPaidByUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedOpenByUserId(Nullable<String> markedOpenByUserId) {
            if (markedOpenByUserId.isNull()) {
                this.markedOpenByUserId = null;
            } else if (markedOpenByUserId.isEmpty()) {
                this.markedOpenByUserId = Optional.empty();
            } else {
                this.markedOpenByUserId = Optional.of(markedOpenByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage markedOpenByUserId(String markedOpenByUserId) {
            this.markedOpenByUserId = Optional.ofNullable(markedOpenByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "marked_open_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage markedOpenByUserId(Optional<String> markedOpenByUserId) {
            this.markedOpenByUserId = markedOpenByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage uncollectibleAtTimestamp(Nullable<OffsetDateTime> uncollectibleAtTimestamp) {
            if (uncollectibleAtTimestamp.isNull()) {
                this.uncollectibleAtTimestamp = null;
            } else if (uncollectibleAtTimestamp.isEmpty()) {
                this.uncollectibleAtTimestamp = Optional.empty();
            } else {
                this.uncollectibleAtTimestamp = Optional.of(uncollectibleAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage uncollectibleAtTimestamp(OffsetDateTime uncollectibleAtTimestamp) {
            this.uncollectibleAtTimestamp = Optional.ofNullable(uncollectibleAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "uncollectible_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage uncollectibleAtTimestamp(Optional<OffsetDateTime> uncollectibleAtTimestamp) {
            this.uncollectibleAtTimestamp = uncollectibleAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage paidAtTimestamp(Nullable<OffsetDateTime> paidAtTimestamp) {
            if (paidAtTimestamp.isNull()) {
                this.paidAtTimestamp = null;
            } else if (paidAtTimestamp.isEmpty()) {
                this.paidAtTimestamp = Optional.empty();
            } else {
                this.paidAtTimestamp = Optional.of(paidAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage paidAtTimestamp(OffsetDateTime paidAtTimestamp) {
            this.paidAtTimestamp = Optional.ofNullable(paidAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "paid_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage paidAtTimestamp(Optional<OffsetDateTime> paidAtTimestamp) {
            this.paidAtTimestamp = paidAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage openedAtTimestamp(Nullable<OffsetDateTime> openedAtTimestamp) {
            if (openedAtTimestamp.isNull()) {
                this.openedAtTimestamp = null;
            } else if (openedAtTimestamp.isEmpty()) {
                this.openedAtTimestamp = Optional.empty();
            } else {
                this.openedAtTimestamp = Optional.of(openedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage openedAtTimestamp(OffsetDateTime openedAtTimestamp) {
            this.openedAtTimestamp = Optional.ofNullable(openedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "opened_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage openedAtTimestamp(Optional<OffsetDateTime> openedAtTimestamp) {
            this.openedAtTimestamp = openedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceStatus(Nullable<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            if (stripeInvoiceStatus.isNull()) {
                this.stripeInvoiceStatus = null;
            } else if (stripeInvoiceStatus.isEmpty()) {
                this.stripeInvoiceStatus = Optional.empty();
            } else {
                this.stripeInvoiceStatus = Optional.of(stripeInvoiceStatus.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus) {
            this.stripeInvoiceStatus = Optional.ofNullable(stripeInvoiceStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_status", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            this.stripeInvoiceStatus = stripeInvoiceStatus;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId) {
            if (stripeInvoiceCreatedByUserId.isNull()) {
                this.stripeInvoiceCreatedByUserId = null;
            } else if (stripeInvoiceCreatedByUserId.isEmpty()) {
                this.stripeInvoiceCreatedByUserId = Optional.empty();
            } else {
                this.stripeInvoiceCreatedByUserId = Optional.of(stripeInvoiceCreatedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = Optional.ofNullable(stripeInvoiceCreatedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_created_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl) {
            if (stripeInvoiceUrl.isNull()) {
                this.stripeInvoiceUrl = null;
            } else if (stripeInvoiceUrl.isEmpty()) {
                this.stripeInvoiceUrl = Optional.empty();
            } else {
                this.stripeInvoiceUrl = Optional.of(stripeInvoiceUrl.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl) {
            this.stripeInvoiceUrl = Optional.ofNullable(stripeInvoiceUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_url", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId) {
            if (stripeInvoiceId.isNull()) {
                this.stripeInvoiceId = null;
            } else if (stripeInvoiceId.isEmpty()) {
                this.stripeInvoiceId = Optional.empty();
            } else {
                this.stripeInvoiceId = Optional.of(stripeInvoiceId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceId(String stripeInvoiceId) {
            this.stripeInvoiceId = Optional.ofNullable(stripeInvoiceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_id", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(StatementStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<StatementStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            if (paymentDestinationDriverId.isNull()) {
                this.paymentDestinationDriverId = null;
            } else if (paymentDestinationDriverId.isEmpty()) {
                this.paymentDestinationDriverId = Optional.empty();
            } else {
                this.paymentDestinationDriverId = Optional.of(paymentDestinationDriverId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_destination_driver_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            if (paymentDestinationOrgId.isNull()) {
                this.paymentDestinationOrgId = null;
            } else if (paymentDestinationOrgId.isEmpty()) {
                this.paymentDestinationOrgId = Optional.empty();
            } else {
                this.paymentDestinationOrgId = Optional.of(paymentDestinationOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_destination_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            if (paymentOriginOffChrtShipperOrgId.isNull()) {
                this.paymentOriginOffChrtShipperOrgId = null;
            } else if (paymentOriginOffChrtShipperOrgId.isEmpty()) {
                this.paymentOriginOffChrtShipperOrgId = Optional.empty();
            } else {
                this.paymentOriginOffChrtShipperOrgId = Optional.of(paymentOriginOffChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_origin_off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            if (paymentOriginOrgId.isNull()) {
                this.paymentOriginOrgId = null;
            } else if (paymentOriginOrgId.isEmpty()) {
                this.paymentOriginOrgId = Optional.empty();
            } else {
                this.paymentOriginOrgId = Optional.of(paymentOriginOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "payment_origin_org_id", nulls = Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stagedByUserId(Nullable<String> stagedByUserId) {
            if (stagedByUserId.isNull()) {
                this.stagedByUserId = null;
            } else if (stagedByUserId.isEmpty()) {
                this.stagedByUserId = Optional.empty();
            } else {
                this.stagedByUserId = Optional.of(stagedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stagedByUserId(String stagedByUserId) {
            this.stagedByUserId = Optional.ofNullable(stagedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "staged_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage stagedByUserId(Optional<String> stagedByUserId) {
            this.stagedByUserId = stagedByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage units(UnitsEnum units) {
            this.units = Optional.ofNullable(units);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "units", nulls = Nulls.SKIP)
        public _FinalStage units(Optional<UnitsEnum> units) {
            this.units = units;
            return this;
        }

        @java.lang.Override
        public _FinalStage lineItemGroupIds(List<String> lineItemGroupIds) {
            this.lineItemGroupIds = Optional.ofNullable(lineItemGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_item_group_ids", nulls = Nulls.SKIP)
        public _FinalStage lineItemGroupIds(Optional<List<String>> lineItemGroupIds) {
            this.lineItemGroupIds = lineItemGroupIds;
            return this;
        }

        @java.lang.Override
        public Statement1 build() {
            return new Statement1(
                    schemaVersion,
                    id,
                    lineItemGroupIds,
                    amount,
                    units,
                    stagedByUserId,
                    settlementType,
                    ownedByOrgId,
                    paymentVectorType,
                    paymentOriginOrgId,
                    paymentOriginOffChrtShipperOrgId,
                    paymentDestinationOrgId,
                    paymentDestinationDriverId,
                    status,
                    stripeInvoiceId,
                    stripeInvoiceUrl,
                    stripeInvoiceCreatedByUserId,
                    stripeInvoiceStatus,
                    stagedAtTimestamp,
                    openedAtTimestamp,
                    paidAtTimestamp,
                    uncollectibleAtTimestamp,
                    markedOpenByUserId,
                    markedPaidByUserId,
                    markedUncollectibleByUserId,
                    additionalProperties);
        }
    }
}
