/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StatementExpandedRes.Builder.class)
public final class StatementExpandedRes {
    private final Statement1 statement;

    private final List<LineItemGroup1> lineItemGroups;

    private final Map<String, Object> additionalProperties;

    private StatementExpandedRes(
            Statement1 statement, List<LineItemGroup1> lineItemGroups, Map<String, Object> additionalProperties) {
        this.statement = statement;
        this.lineItemGroups = lineItemGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("statement")
    public Statement1 getStatement() {
        return statement;
    }

    @JsonProperty("line_item_groups")
    public List<LineItemGroup1> getLineItemGroups() {
        return lineItemGroups;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StatementExpandedRes && equalTo((StatementExpandedRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementExpandedRes other) {
        return statement.equals(other.statement) && lineItemGroups.equals(other.lineItemGroups);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.statement, this.lineItemGroups);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatementStage builder() {
        return new Builder();
    }

    public interface StatementStage {
        _FinalStage statement(@NotNull Statement1 statement);

        Builder from(StatementExpandedRes other);
    }

    public interface _FinalStage {
        StatementExpandedRes build();

        _FinalStage lineItemGroups(List<LineItemGroup1> lineItemGroups);

        _FinalStage addLineItemGroups(LineItemGroup1 lineItemGroups);

        _FinalStage addAllLineItemGroups(List<LineItemGroup1> lineItemGroups);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements StatementStage, _FinalStage {
        private Statement1 statement;

        private List<LineItemGroup1> lineItemGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StatementExpandedRes other) {
            statement(other.getStatement());
            lineItemGroups(other.getLineItemGroups());
            return this;
        }

        @java.lang.Override
        @JsonSetter("statement")
        public _FinalStage statement(@NotNull Statement1 statement) {
            this.statement = Objects.requireNonNull(statement, "statement must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLineItemGroups(List<LineItemGroup1> lineItemGroups) {
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLineItemGroups(LineItemGroup1 lineItemGroups) {
            this.lineItemGroups.add(lineItemGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_item_groups", nulls = Nulls.SKIP)
        public _FinalStage lineItemGroups(List<LineItemGroup1> lineItemGroups) {
            this.lineItemGroups.clear();
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @java.lang.Override
        public StatementExpandedRes build() {
            return new StatementExpandedRes(statement, lineItemGroups, additionalProperties);
        }
    }
}
