/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StatementsListRes.Builder.class)
public final class StatementsListRes {
    private final List<Statement1> statements;

    private final int totalCount;

    private final Map<String, Object> additionalProperties;

    private StatementsListRes(List<Statement1> statements, int totalCount, Map<String, Object> additionalProperties) {
        this.statements = statements;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("statements")
    public List<Statement1> getStatements() {
        return statements;
    }

    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StatementsListRes && equalTo((StatementsListRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementsListRes other) {
        return statements.equals(other.statements) && totalCount == other.totalCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.statements, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        _FinalStage totalCount(int totalCount);

        Builder from(StatementsListRes other);
    }

    public interface _FinalStage {
        StatementsListRes build();

        _FinalStage statements(List<Statement1> statements);

        _FinalStage addStatements(Statement1 statements);

        _FinalStage addAllStatements(List<Statement1> statements);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<Statement1> statements = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StatementsListRes other) {
            statements(other.getStatements());
            totalCount(other.getTotalCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllStatements(List<Statement1> statements) {
            if (statements != null) {
                this.statements.addAll(statements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addStatements(Statement1 statements) {
            this.statements.add(statements);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "statements", nulls = Nulls.SKIP)
        public _FinalStage statements(List<Statement1> statements) {
            this.statements.clear();
            if (statements != null) {
                this.statements.addAll(statements);
            }
            return this;
        }

        @java.lang.Override
        public StatementsListRes build() {
            return new StatementsListRes(statements, totalCount, additionalProperties);
        }
    }
}
