/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Task1.Builder.class)
public final class Task1 {
    private final int schemaVersion;

    private final Optional<LocationFeature> location;

    private final Optional<Action> action;

    private final Optional<List<TimeWindow1>> timeWindows;

    private final Optional<String> orderPlacerComments;

    private final Optional<List<String>> shipperContactIds;

    private final String id;

    private final String orderId;

    private final String orderShortId;

    private final String taskGroupId;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<String> completedByOrgId;

    private final Optional<String> completedByUserId;

    private final Optional<List<String>> cargoIds;

    private final Optional<List<String>> taskArtifactIds;

    private final Optional<TaskStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> completedAtTimestamp;

    private final Optional<OffsetDateTime> skippedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Optional<Boolean> orderCancelled;

    private final Optional<List<String>> taskNotificationEmailIds;

    private final Optional<List<String>> taskNotificationSmsIds;

    private final Optional<List<String>> taskNotificationPushIds;

    private final Optional<List<String>> taskNotificationVoiceIds;

    private final Map<String, Object> additionalProperties;

    private Task1(
            int schemaVersion,
            Optional<LocationFeature> location,
            Optional<Action> action,
            Optional<List<TimeWindow1>> timeWindows,
            Optional<String> orderPlacerComments,
            Optional<List<String>> shipperContactIds,
            String id,
            String orderId,
            String orderShortId,
            String taskGroupId,
            String createdByOrgId,
            String createdByUserId,
            Optional<String> completedByOrgId,
            Optional<String> completedByUserId,
            Optional<List<String>> cargoIds,
            Optional<List<String>> taskArtifactIds,
            Optional<TaskStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> completedAtTimestamp,
            Optional<OffsetDateTime> skippedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Optional<Boolean> orderCancelled,
            Optional<List<String>> taskNotificationEmailIds,
            Optional<List<String>> taskNotificationSmsIds,
            Optional<List<String>> taskNotificationPushIds,
            Optional<List<String>> taskNotificationVoiceIds,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.orderPlacerComments = orderPlacerComments;
        this.shipperContactIds = shipperContactIds;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskGroupId = taskGroupId;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.completedByOrgId = completedByOrgId;
        this.completedByUserId = completedByUserId;
        this.cargoIds = cargoIds;
        this.taskArtifactIds = taskArtifactIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.taskNotificationEmailIds = taskNotificationEmailIds;
        this.taskNotificationSmsIds = taskNotificationSmsIds;
        this.taskNotificationPushIds = taskNotificationPushIds;
        this.taskNotificationVoiceIds = taskNotificationVoiceIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (location == null) {
            return Optional.empty();
        }
        return location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (action == null) {
            return Optional.empty();
        }
        return action;
    }

    @JsonProperty("time_windows")
    public Optional<List<TimeWindow1>> getTimeWindows() {
        return timeWindows;
    }

    @JsonIgnore
    public Optional<String> getOrderPlacerComments() {
        if (orderPlacerComments == null) {
            return Optional.empty();
        }
        return orderPlacerComments;
    }

    @JsonProperty("shipper_contact_ids")
    public Optional<List<String>> getShipperContactIds() {
        return shipperContactIds;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCompletedByOrgId() {
        if (completedByOrgId == null) {
            return Optional.empty();
        }
        return completedByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getCompletedByUserId() {
        if (completedByUserId == null) {
            return Optional.empty();
        }
        return completedByUserId;
    }

    @JsonProperty("cargo_ids")
    public Optional<List<String>> getCargoIds() {
        return cargoIds;
    }

    @JsonProperty("task_artifact_ids")
    public Optional<List<String>> getTaskArtifactIds() {
        return taskArtifactIds;
    }

    @JsonProperty("status")
    public Optional<TaskStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (completedAtTimestamp == null) {
            return Optional.empty();
        }
        return completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonProperty("task_notification_email_ids")
    public Optional<List<String>> getTaskNotificationEmailIds() {
        return taskNotificationEmailIds;
    }

    @JsonProperty("task_notification_sms_ids")
    public Optional<List<String>> getTaskNotificationSmsIds() {
        return taskNotificationSmsIds;
    }

    @JsonProperty("task_notification_push_ids")
    public Optional<List<String>> getTaskNotificationPushIds() {
        return taskNotificationPushIds;
    }

    @JsonProperty("task_notification_voice_ids")
    public Optional<List<String>> getTaskNotificationVoiceIds() {
        return taskNotificationVoiceIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("location")
    private Optional<LocationFeature> _getLocation() {
        return location;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("action")
    private Optional<Action> _getAction() {
        return action;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("order_placer_comments")
    private Optional<String> _getOrderPlacerComments() {
        return orderPlacerComments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_by_org_id")
    private Optional<String> _getCompletedByOrgId() {
        return completedByOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_by_user_id")
    private Optional<String> _getCompletedByUserId() {
        return completedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return completedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return skippedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Task1 && equalTo((Task1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Task1 other) {
        return schemaVersion == other.schemaVersion
                && location.equals(other.location)
                && action.equals(other.action)
                && timeWindows.equals(other.timeWindows)
                && orderPlacerComments.equals(other.orderPlacerComments)
                && shipperContactIds.equals(other.shipperContactIds)
                && id.equals(other.id)
                && orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && taskGroupId.equals(other.taskGroupId)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && completedByOrgId.equals(other.completedByOrgId)
                && completedByUserId.equals(other.completedByUserId)
                && cargoIds.equals(other.cargoIds)
                && taskArtifactIds.equals(other.taskArtifactIds)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && completedAtTimestamp.equals(other.completedAtTimestamp)
                && skippedAtTimestamp.equals(other.skippedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp)
                && orderCancelled.equals(other.orderCancelled)
                && taskNotificationEmailIds.equals(other.taskNotificationEmailIds)
                && taskNotificationSmsIds.equals(other.taskNotificationSmsIds)
                && taskNotificationPushIds.equals(other.taskNotificationPushIds)
                && taskNotificationVoiceIds.equals(other.taskNotificationVoiceIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.location,
                this.action,
                this.timeWindows,
                this.orderPlacerComments,
                this.shipperContactIds,
                this.id,
                this.orderId,
                this.orderShortId,
                this.taskGroupId,
                this.createdByOrgId,
                this.createdByUserId,
                this.completedByOrgId,
                this.completedByUserId,
                this.cargoIds,
                this.taskArtifactIds,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.completedAtTimestamp,
                this.skippedAtTimestamp,
                this.exceptionAtTimestamp,
                this.orderCancelled,
                this.taskNotificationEmailIds,
                this.taskNotificationSmsIds,
                this.taskNotificationPushIds,
                this.taskNotificationVoiceIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(Task1 other);
    }

    public interface IdStage {
        OrderIdStage id(@NotNull String id);
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);
    }

    public interface OrderShortIdStage {
        TaskGroupIdStage orderShortId(@NotNull String orderShortId);
    }

    public interface TaskGroupIdStage {
        CreatedByOrgIdStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface _FinalStage {
        Task1 build();

        _FinalStage location(Optional<LocationFeature> location);

        _FinalStage location(LocationFeature location);

        _FinalStage location(Nullable<LocationFeature> location);

        _FinalStage action(Optional<Action> action);

        _FinalStage action(Action action);

        _FinalStage action(Nullable<Action> action);

        _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows);

        _FinalStage timeWindows(List<TimeWindow1> timeWindows);

        _FinalStage orderPlacerComments(Optional<String> orderPlacerComments);

        _FinalStage orderPlacerComments(String orderPlacerComments);

        _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments);

        _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds);

        _FinalStage shipperContactIds(List<String> shipperContactIds);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage completedByOrgId(Optional<String> completedByOrgId);

        _FinalStage completedByOrgId(String completedByOrgId);

        _FinalStage completedByOrgId(Nullable<String> completedByOrgId);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage completedByUserId(Optional<String> completedByUserId);

        _FinalStage completedByUserId(String completedByUserId);

        _FinalStage completedByUserId(Nullable<String> completedByUserId);

        _FinalStage cargoIds(Optional<List<String>> cargoIds);

        _FinalStage cargoIds(List<String> cargoIds);

        _FinalStage taskArtifactIds(Optional<List<String>> taskArtifactIds);

        _FinalStage taskArtifactIds(List<String> taskArtifactIds);

        _FinalStage status(Optional<TaskStatusEnum1> status);

        _FinalStage status(TaskStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp);

        _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp);

        _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp);

        _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage taskNotificationEmailIds(Optional<List<String>> taskNotificationEmailIds);

        _FinalStage taskNotificationEmailIds(List<String> taskNotificationEmailIds);

        _FinalStage taskNotificationSmsIds(Optional<List<String>> taskNotificationSmsIds);

        _FinalStage taskNotificationSmsIds(List<String> taskNotificationSmsIds);

        _FinalStage taskNotificationPushIds(Optional<List<String>> taskNotificationPushIds);

        _FinalStage taskNotificationPushIds(List<String> taskNotificationPushIds);

        _FinalStage taskNotificationVoiceIds(Optional<List<String>> taskNotificationVoiceIds);

        _FinalStage taskNotificationVoiceIds(List<String> taskNotificationVoiceIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    OrderIdStage,
                    OrderShortIdStage,
                    TaskGroupIdStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String orderId;

        private String orderShortId;

        private String taskGroupId;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private Optional<List<String>> taskNotificationVoiceIds = Optional.empty();

        private Optional<List<String>> taskNotificationPushIds = Optional.empty();

        private Optional<List<String>> taskNotificationSmsIds = Optional.empty();

        private Optional<List<String>> taskNotificationEmailIds = Optional.empty();

        private Optional<Boolean> orderCancelled = Optional.empty();

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<TaskStatusEnum1> status = Optional.empty();

        private Optional<List<String>> taskArtifactIds = Optional.empty();

        private Optional<List<String>> cargoIds = Optional.empty();

        private Optional<String> completedByUserId = Optional.empty();

        private Optional<String> completedByOrgId = Optional.empty();

        private Optional<List<String>> shipperContactIds = Optional.empty();

        private Optional<String> orderPlacerComments = Optional.empty();

        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();

        private Optional<Action> action = Optional.empty();

        private Optional<LocationFeature> location = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Task1 other) {
            schemaVersion(other.getSchemaVersion());
            location(other.getLocation());
            action(other.getAction());
            timeWindows(other.getTimeWindows());
            orderPlacerComments(other.getOrderPlacerComments());
            shipperContactIds(other.getShipperContactIds());
            id(other.getId());
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            taskGroupId(other.getTaskGroupId());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            completedByOrgId(other.getCompletedByOrgId());
            completedByUserId(other.getCompletedByUserId());
            cargoIds(other.getCargoIds());
            taskArtifactIds(other.getTaskArtifactIds());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            completedAtTimestamp(other.getCompletedAtTimestamp());
            skippedAtTimestamp(other.getSkippedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            orderCancelled(other.getOrderCancelled());
            taskNotificationEmailIds(other.getTaskNotificationEmailIds());
            taskNotificationSmsIds(other.getTaskNotificationSmsIds());
            taskNotificationPushIds(other.getTaskNotificationPushIds());
            taskNotificationVoiceIds(other.getTaskNotificationVoiceIds());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public TaskGroupIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public CreatedByOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage taskNotificationVoiceIds(List<String> taskNotificationVoiceIds) {
            this.taskNotificationVoiceIds = Optional.ofNullable(taskNotificationVoiceIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_notification_voice_ids", nulls = Nulls.SKIP)
        public _FinalStage taskNotificationVoiceIds(Optional<List<String>> taskNotificationVoiceIds) {
            this.taskNotificationVoiceIds = taskNotificationVoiceIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskNotificationPushIds(List<String> taskNotificationPushIds) {
            this.taskNotificationPushIds = Optional.ofNullable(taskNotificationPushIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_notification_push_ids", nulls = Nulls.SKIP)
        public _FinalStage taskNotificationPushIds(Optional<List<String>> taskNotificationPushIds) {
            this.taskNotificationPushIds = taskNotificationPushIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskNotificationSmsIds(List<String> taskNotificationSmsIds) {
            this.taskNotificationSmsIds = Optional.ofNullable(taskNotificationSmsIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_notification_sms_ids", nulls = Nulls.SKIP)
        public _FinalStage taskNotificationSmsIds(Optional<List<String>> taskNotificationSmsIds) {
            this.taskNotificationSmsIds = taskNotificationSmsIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskNotificationEmailIds(List<String> taskNotificationEmailIds) {
            this.taskNotificationEmailIds = Optional.ofNullable(taskNotificationEmailIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_notification_email_ids", nulls = Nulls.SKIP)
        public _FinalStage taskNotificationEmailIds(Optional<List<String>> taskNotificationEmailIds) {
            this.taskNotificationEmailIds = taskNotificationEmailIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            if (skippedAtTimestamp.isNull()) {
                this.skippedAtTimestamp = null;
            } else if (skippedAtTimestamp.isEmpty()) {
                this.skippedAtTimestamp = Optional.empty();
            } else {
                this.skippedAtTimestamp = Optional.of(skippedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "skipped_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            if (completedAtTimestamp.isNull()) {
                this.completedAtTimestamp = null;
            } else if (completedAtTimestamp.isEmpty()) {
                this.completedAtTimestamp = Optional.empty();
            } else {
                this.completedAtTimestamp = Optional.of(completedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(TaskStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<TaskStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskArtifactIds(List<String> taskArtifactIds) {
            this.taskArtifactIds = Optional.ofNullable(taskArtifactIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_artifact_ids", nulls = Nulls.SKIP)
        public _FinalStage taskArtifactIds(Optional<List<String>> taskArtifactIds) {
            this.taskArtifactIds = taskArtifactIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoIds(List<String> cargoIds) {
            this.cargoIds = Optional.ofNullable(cargoIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargo_ids", nulls = Nulls.SKIP)
        public _FinalStage cargoIds(Optional<List<String>> cargoIds) {
            this.cargoIds = cargoIds;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByUserId(Nullable<String> completedByUserId) {
            if (completedByUserId.isNull()) {
                this.completedByUserId = null;
            } else if (completedByUserId.isEmpty()) {
                this.completedByUserId = Optional.empty();
            } else {
                this.completedByUserId = Optional.of(completedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByUserId(String completedByUserId) {
            this.completedByUserId = Optional.ofNullable(completedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "completed_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage completedByUserId(Optional<String> completedByUserId) {
            this.completedByUserId = completedByUserId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByOrgId(Nullable<String> completedByOrgId) {
            if (completedByOrgId.isNull()) {
                this.completedByOrgId = null;
            } else if (completedByOrgId.isEmpty()) {
                this.completedByOrgId = Optional.empty();
            } else {
                this.completedByOrgId = Optional.of(completedByOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage completedByOrgId(String completedByOrgId) {
            this.completedByOrgId = Optional.ofNullable(completedByOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "completed_by_org_id", nulls = Nulls.SKIP)
        public _FinalStage completedByOrgId(Optional<String> completedByOrgId) {
            this.completedByOrgId = completedByOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperContactIds(List<String> shipperContactIds) {
            this.shipperContactIds = Optional.ofNullable(shipperContactIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_contact_ids", nulls = Nulls.SKIP)
        public _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds) {
            this.shipperContactIds = shipperContactIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments) {
            if (orderPlacerComments.isNull()) {
                this.orderPlacerComments = null;
            } else if (orderPlacerComments.isEmpty()) {
                this.orderPlacerComments = Optional.empty();
            } else {
                this.orderPlacerComments = Optional.of(orderPlacerComments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orderPlacerComments(String orderPlacerComments) {
            this.orderPlacerComments = Optional.ofNullable(orderPlacerComments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_placer_comments", nulls = Nulls.SKIP)
        public _FinalStage orderPlacerComments(Optional<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments;
            return this;
        }

        @java.lang.Override
        public _FinalStage timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "time_windows", nulls = Nulls.SKIP)
        public _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        @java.lang.Override
        public _FinalStage action(Nullable<Action> action) {
            if (action.isNull()) {
                this.action = null;
            } else if (action.isEmpty()) {
                this.action = Optional.empty();
            } else {
                this.action = Optional.of(action.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public _FinalStage action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        @java.lang.Override
        public _FinalStage location(Nullable<LocationFeature> location) {
            if (location.isNull()) {
                this.location = null;
            } else if (location.isEmpty()) {
                this.location = Optional.empty();
            } else {
                this.location = Optional.of(location.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public _FinalStage location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        @java.lang.Override
        public Task1 build() {
            return new Task1(
                    schemaVersion,
                    location,
                    action,
                    timeWindows,
                    orderPlacerComments,
                    shipperContactIds,
                    id,
                    orderId,
                    orderShortId,
                    taskGroupId,
                    createdByOrgId,
                    createdByUserId,
                    completedByOrgId,
                    completedByUserId,
                    cargoIds,
                    taskArtifactIds,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    completedAtTimestamp,
                    skippedAtTimestamp,
                    exceptionAtTimestamp,
                    orderCancelled,
                    taskNotificationEmailIds,
                    taskNotificationSmsIds,
                    taskNotificationPushIds,
                    taskNotificationVoiceIds,
                    additionalProperties);
        }
    }
}
