/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskArtifactNotificationPreferences1.Builder.class)
public final class TaskArtifactNotificationPreferences1 {
    private final int schemaVersion;

    private final Optional<List<String>> emailAddresses;

    private final Optional<List<String>> smsPhoneNumbers;

    private final Optional<List<String>> voicePhoneNumbers;

    private final Optional<Map<String, List<NotificationChannelEnum>>> preferences;

    private final String orgId;

    private final String createdByUserId;

    private final OffsetDateTime createdAtTimestamp;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private TaskArtifactNotificationPreferences1(
            int schemaVersion,
            Optional<List<String>> emailAddresses,
            Optional<List<String>> smsPhoneNumbers,
            Optional<List<String>> voicePhoneNumbers,
            Optional<Map<String, List<NotificationChannelEnum>>> preferences,
            String orgId,
            String createdByUserId,
            OffsetDateTime createdAtTimestamp,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.emailAddresses = emailAddresses;
        this.smsPhoneNumbers = smsPhoneNumbers;
        this.voicePhoneNumbers = voicePhoneNumbers;
        this.preferences = preferences;
        this.orgId = orgId;
        this.createdByUserId = createdByUserId;
        this.createdAtTimestamp = createdAtTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("email_addresses")
    public Optional<List<String>> getEmailAddresses() {
        return emailAddresses;
    }

    @JsonProperty("sms_phone_numbers")
    public Optional<List<String>> getSmsPhoneNumbers() {
        return smsPhoneNumbers;
    }

    @JsonProperty("voice_phone_numbers")
    public Optional<List<String>> getVoicePhoneNumbers() {
        return voicePhoneNumbers;
    }

    /**
     * @return For each ChrtGroundCourierTaskActionEnum1, which channels (email/sms/voice) are enabled
     */
    @JsonProperty("preferences")
    public Optional<Map<String, List<NotificationChannelEnum>>> getPreferences() {
        return preferences;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    @JsonProperty("created_at_timestamp")
    public OffsetDateTime getCreatedAtTimestamp() {
        return createdAtTimestamp;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskArtifactNotificationPreferences1
                && equalTo((TaskArtifactNotificationPreferences1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskArtifactNotificationPreferences1 other) {
        return schemaVersion == other.schemaVersion
                && emailAddresses.equals(other.emailAddresses)
                && smsPhoneNumbers.equals(other.smsPhoneNumbers)
                && voicePhoneNumbers.equals(other.voicePhoneNumbers)
                && preferences.equals(other.preferences)
                && orgId.equals(other.orgId)
                && createdByUserId.equals(other.createdByUserId)
                && createdAtTimestamp.equals(other.createdAtTimestamp)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.emailAddresses,
                this.smsPhoneNumbers,
                this.voicePhoneNumbers,
                this.preferences,
                this.orgId,
                this.createdByUserId,
                this.createdAtTimestamp,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        OrgIdStage schemaVersion(int schemaVersion);

        Builder from(TaskArtifactNotificationPreferences1 other);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage orgId(@NotNull String orgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        CreatedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface CreatedAtTimestampStage {
        IdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        TaskArtifactNotificationPreferences1 build();

        _FinalStage emailAddresses(Optional<List<String>> emailAddresses);

        _FinalStage emailAddresses(List<String> emailAddresses);

        _FinalStage smsPhoneNumbers(Optional<List<String>> smsPhoneNumbers);

        _FinalStage smsPhoneNumbers(List<String> smsPhoneNumbers);

        _FinalStage voicePhoneNumbers(Optional<List<String>> voicePhoneNumbers);

        _FinalStage voicePhoneNumbers(List<String> voicePhoneNumbers);

        /**
         * <p>For each ChrtGroundCourierTaskActionEnum1, which channels (email/sms/voice) are enabled</p>
         */
        _FinalStage preferences(Optional<Map<String, List<NotificationChannelEnum>>> preferences);

        _FinalStage preferences(Map<String, List<NotificationChannelEnum>> preferences);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    OrgIdStage,
                    CreatedByUserIdStage,
                    CreatedAtTimestampStage,
                    IdStage,
                    _FinalStage {
        private int schemaVersion;

        private String orgId;

        private String createdByUserId;

        private OffsetDateTime createdAtTimestamp;

        private String id;

        private Optional<Map<String, List<NotificationChannelEnum>>> preferences = Optional.empty();

        private Optional<List<String>> voicePhoneNumbers = Optional.empty();

        private Optional<List<String>> smsPhoneNumbers = Optional.empty();

        private Optional<List<String>> emailAddresses = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskArtifactNotificationPreferences1 other) {
            schemaVersion(other.getSchemaVersion());
            emailAddresses(other.getEmailAddresses());
            smsPhoneNumbers(other.getSmsPhoneNumbers());
            voicePhoneNumbers(other.getVoicePhoneNumbers());
            preferences(other.getPreferences());
            orgId(other.getOrgId());
            createdByUserId(other.getCreatedByUserId());
            createdAtTimestamp(other.getCreatedAtTimestamp());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public OrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public CreatedByUserIdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public CreatedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at_timestamp")
        public IdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Objects.requireNonNull(createdAtTimestamp, "createdAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>For each ChrtGroundCourierTaskActionEnum1, which channels (email/sms/voice) are enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage preferences(Map<String, List<NotificationChannelEnum>> preferences) {
            this.preferences = Optional.ofNullable(preferences);
            return this;
        }

        /**
         * <p>For each ChrtGroundCourierTaskActionEnum1, which channels (email/sms/voice) are enabled</p>
         */
        @java.lang.Override
        @JsonSetter(value = "preferences", nulls = Nulls.SKIP)
        public _FinalStage preferences(Optional<Map<String, List<NotificationChannelEnum>>> preferences) {
            this.preferences = preferences;
            return this;
        }

        @java.lang.Override
        public _FinalStage voicePhoneNumbers(List<String> voicePhoneNumbers) {
            this.voicePhoneNumbers = Optional.ofNullable(voicePhoneNumbers);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "voice_phone_numbers", nulls = Nulls.SKIP)
        public _FinalStage voicePhoneNumbers(Optional<List<String>> voicePhoneNumbers) {
            this.voicePhoneNumbers = voicePhoneNumbers;
            return this;
        }

        @java.lang.Override
        public _FinalStage smsPhoneNumbers(List<String> smsPhoneNumbers) {
            this.smsPhoneNumbers = Optional.ofNullable(smsPhoneNumbers);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sms_phone_numbers", nulls = Nulls.SKIP)
        public _FinalStage smsPhoneNumbers(Optional<List<String>> smsPhoneNumbers) {
            this.smsPhoneNumbers = smsPhoneNumbers;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddresses(List<String> emailAddresses) {
            this.emailAddresses = Optional.ofNullable(emailAddresses);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_addresses", nulls = Nulls.SKIP)
        public _FinalStage emailAddresses(Optional<List<String>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        @java.lang.Override
        public TaskArtifactNotificationPreferences1 build() {
            return new TaskArtifactNotificationPreferences1(
                    schemaVersion,
                    emailAddresses,
                    smsPhoneNumbers,
                    voicePhoneNumbers,
                    preferences,
                    orgId,
                    createdByUserId,
                    createdAtTimestamp,
                    id,
                    additionalProperties);
        }
    }
}
