/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskClientCreate1.Builder.class)
public final class TaskClientCreate1 {
    private final int schemaVersion;

    private final Optional<LocationFeature> location;

    private final Optional<Action> action;

    private final Optional<List<TimeWindow1>> timeWindows;

    private final Optional<String> orderPlacerComments;

    private final Optional<List<String>> shipperContactIds;

    private final Map<String, Object> additionalProperties;

    private TaskClientCreate1(
            int schemaVersion,
            Optional<LocationFeature> location,
            Optional<Action> action,
            Optional<List<TimeWindow1>> timeWindows,
            Optional<String> orderPlacerComments,
            Optional<List<String>> shipperContactIds,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.orderPlacerComments = orderPlacerComments;
        this.shipperContactIds = shipperContactIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (location == null) {
            return Optional.empty();
        }
        return location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (action == null) {
            return Optional.empty();
        }
        return action;
    }

    @JsonProperty("time_windows")
    public Optional<List<TimeWindow1>> getTimeWindows() {
        return timeWindows;
    }

    @JsonIgnore
    public Optional<String> getOrderPlacerComments() {
        if (orderPlacerComments == null) {
            return Optional.empty();
        }
        return orderPlacerComments;
    }

    @JsonProperty("shipper_contact_ids")
    public Optional<List<String>> getShipperContactIds() {
        return shipperContactIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("location")
    private Optional<LocationFeature> _getLocation() {
        return location;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("action")
    private Optional<Action> _getAction() {
        return action;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("order_placer_comments")
    private Optional<String> _getOrderPlacerComments() {
        return orderPlacerComments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskClientCreate1 && equalTo((TaskClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskClientCreate1 other) {
        return schemaVersion == other.schemaVersion
                && location.equals(other.location)
                && action.equals(other.action)
                && timeWindows.equals(other.timeWindows)
                && orderPlacerComments.equals(other.orderPlacerComments)
                && shipperContactIds.equals(other.shipperContactIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.location,
                this.action,
                this.timeWindows,
                this.orderPlacerComments,
                this.shipperContactIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        _FinalStage schemaVersion(int schemaVersion);

        Builder from(TaskClientCreate1 other);
    }

    public interface _FinalStage {
        TaskClientCreate1 build();

        _FinalStage location(Optional<LocationFeature> location);

        _FinalStage location(LocationFeature location);

        _FinalStage location(Nullable<LocationFeature> location);

        _FinalStage action(Optional<Action> action);

        _FinalStage action(Action action);

        _FinalStage action(Nullable<Action> action);

        _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows);

        _FinalStage timeWindows(List<TimeWindow1> timeWindows);

        _FinalStage orderPlacerComments(Optional<String> orderPlacerComments);

        _FinalStage orderPlacerComments(String orderPlacerComments);

        _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments);

        _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds);

        _FinalStage shipperContactIds(List<String> shipperContactIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, _FinalStage {
        private int schemaVersion;

        private Optional<List<String>> shipperContactIds = Optional.empty();

        private Optional<String> orderPlacerComments = Optional.empty();

        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();

        private Optional<Action> action = Optional.empty();

        private Optional<LocationFeature> location = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            location(other.getLocation());
            action(other.getAction());
            timeWindows(other.getTimeWindows());
            orderPlacerComments(other.getOrderPlacerComments());
            shipperContactIds(other.getShipperContactIds());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public _FinalStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperContactIds(List<String> shipperContactIds) {
            this.shipperContactIds = Optional.ofNullable(shipperContactIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_contact_ids", nulls = Nulls.SKIP)
        public _FinalStage shipperContactIds(Optional<List<String>> shipperContactIds) {
            this.shipperContactIds = shipperContactIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderPlacerComments(Nullable<String> orderPlacerComments) {
            if (orderPlacerComments.isNull()) {
                this.orderPlacerComments = null;
            } else if (orderPlacerComments.isEmpty()) {
                this.orderPlacerComments = Optional.empty();
            } else {
                this.orderPlacerComments = Optional.of(orderPlacerComments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orderPlacerComments(String orderPlacerComments) {
            this.orderPlacerComments = Optional.ofNullable(orderPlacerComments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_placer_comments", nulls = Nulls.SKIP)
        public _FinalStage orderPlacerComments(Optional<String> orderPlacerComments) {
            this.orderPlacerComments = orderPlacerComments;
            return this;
        }

        @java.lang.Override
        public _FinalStage timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "time_windows", nulls = Nulls.SKIP)
        public _FinalStage timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        @java.lang.Override
        public _FinalStage action(Nullable<Action> action) {
            if (action.isNull()) {
                this.action = null;
            } else if (action.isEmpty()) {
                this.action = Optional.empty();
            } else {
                this.action = Optional.of(action.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public _FinalStage action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        @java.lang.Override
        public _FinalStage location(Nullable<LocationFeature> location) {
            if (location.isNull()) {
                this.location = null;
            } else if (location.isEmpty()) {
                this.location = Optional.empty();
            } else {
                this.location = Optional.of(location.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public _FinalStage location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        @java.lang.Override
        public TaskClientCreate1 build() {
            return new TaskClientCreate1(
                    schemaVersion,
                    location,
                    action,
                    timeWindows,
                    orderPlacerComments,
                    shipperContactIds,
                    additionalProperties);
        }
    }
}
