/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroup1.Builder.class)
public final class TaskGroup1 {
    private final int schemaVersion;

    private final String id;

    private final String orderId;

    private final String orderShortId;

    private final Optional<List<String>> taskIds;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<String> courierOrgId;

    private final Optional<String> driverId;

    private final Optional<ServiceTypeEnum1> serviceType;

    private final Optional<List<String>> taskGroupS3ObjectMetadataIds;

    private final Optional<TaskGroupStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> inProgressAtTimestamp;

    private final Optional<OffsetDateTime> completedAtTimestamp;

    private final Optional<OffsetDateTime> skippedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Optional<Boolean> orderCancelled;

    private final TaskGroupTypeEnum1 taskGroupType;

    private final Optional<Double> tasksMileage;

    private final Optional<String> flightNumber;

    private final Optional<List<String>> faFlightIds;

    private final Optional<List<TaskGroupMessage1>> messages;

    private final Optional<String> shipperPayForwarderRateSheetId;

    private final Optional<String> shipperPayForwarderLineItemGroupId;

    private final Optional<String> forwarderPayCourierRateSheetId;

    private final Optional<String> forwarderPayCourierLineItemGroupId;

    private final Optional<String> shipperPayCourierRateSheetId;

    private final Optional<String> shipperPayCourierLineItemGroupId;

    private final Optional<String> courierPayDriverRateSheetId;

    private final Optional<String> courierPayDriverLineItemGroupId;

    private final Map<String, Object> additionalProperties;

    private TaskGroup1(
            int schemaVersion,
            String id,
            String orderId,
            String orderShortId,
            Optional<List<String>> taskIds,
            String createdByOrgId,
            String createdByUserId,
            Optional<String> courierOrgId,
            Optional<String> driverId,
            Optional<ServiceTypeEnum1> serviceType,
            Optional<List<String>> taskGroupS3ObjectMetadataIds,
            Optional<TaskGroupStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> inProgressAtTimestamp,
            Optional<OffsetDateTime> completedAtTimestamp,
            Optional<OffsetDateTime> skippedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Optional<Boolean> orderCancelled,
            TaskGroupTypeEnum1 taskGroupType,
            Optional<Double> tasksMileage,
            Optional<String> flightNumber,
            Optional<List<String>> faFlightIds,
            Optional<List<TaskGroupMessage1>> messages,
            Optional<String> shipperPayForwarderRateSheetId,
            Optional<String> shipperPayForwarderLineItemGroupId,
            Optional<String> forwarderPayCourierRateSheetId,
            Optional<String> forwarderPayCourierLineItemGroupId,
            Optional<String> shipperPayCourierRateSheetId,
            Optional<String> shipperPayCourierLineItemGroupId,
            Optional<String> courierPayDriverRateSheetId,
            Optional<String> courierPayDriverLineItemGroupId,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.taskIds = taskIds;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.courierOrgId = courierOrgId;
        this.driverId = driverId;
        this.serviceType = serviceType;
        this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inProgressAtTimestamp = inProgressAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.taskGroupType = taskGroupType;
        this.tasksMileage = tasksMileage;
        this.flightNumber = flightNumber;
        this.faFlightIds = faFlightIds;
        this.messages = messages;
        this.shipperPayForwarderRateSheetId = shipperPayForwarderRateSheetId;
        this.shipperPayForwarderLineItemGroupId = shipperPayForwarderLineItemGroupId;
        this.forwarderPayCourierRateSheetId = forwarderPayCourierRateSheetId;
        this.forwarderPayCourierLineItemGroupId = forwarderPayCourierLineItemGroupId;
        this.shipperPayCourierRateSheetId = shipperPayCourierRateSheetId;
        this.shipperPayCourierLineItemGroupId = shipperPayCourierLineItemGroupId;
        this.courierPayDriverRateSheetId = courierPayDriverRateSheetId;
        this.courierPayDriverLineItemGroupId = courierPayDriverLineItemGroupId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    @JsonProperty("task_ids")
    public Optional<List<String>> getTaskIds() {
        return taskIds;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (courierOrgId == null) {
            return Optional.empty();
        }
        return courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getDriverId() {
        if (driverId == null) {
            return Optional.empty();
        }
        return driverId;
    }

    @JsonProperty("service_type")
    public Optional<ServiceTypeEnum1> getServiceType() {
        return serviceType;
    }

    @JsonProperty("task_group_s3_object_metadata_ids")
    public Optional<List<String>> getTaskGroupS3ObjectMetadataIds() {
        return taskGroupS3ObjectMetadataIds;
    }

    @JsonProperty("status")
    public Optional<TaskGroupStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInProgressAtTimestamp() {
        if (inProgressAtTimestamp == null) {
            return Optional.empty();
        }
        return inProgressAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (completedAtTimestamp == null) {
            return Optional.empty();
        }
        return completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonProperty("task_group_type")
    public TaskGroupTypeEnum1 getTaskGroupType() {
        return taskGroupType;
    }

    @JsonIgnore
    public Optional<Double> getTasksMileage() {
        if (tasksMileage == null) {
            return Optional.empty();
        }
        return tasksMileage;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (flightNumber == null) {
            return Optional.empty();
        }
        return flightNumber;
    }

    @JsonProperty("fa_flight_ids")
    public Optional<List<String>> getFaFlightIds() {
        return faFlightIds;
    }

    @JsonProperty("messages")
    public Optional<List<TaskGroupMessage1>> getMessages() {
        return messages;
    }

    @JsonIgnore
    public Optional<String> getShipperPayForwarderRateSheetId() {
        if (shipperPayForwarderRateSheetId == null) {
            return Optional.empty();
        }
        return shipperPayForwarderRateSheetId;
    }

    @JsonIgnore
    public Optional<String> getShipperPayForwarderLineItemGroupId() {
        if (shipperPayForwarderLineItemGroupId == null) {
            return Optional.empty();
        }
        return shipperPayForwarderLineItemGroupId;
    }

    @JsonIgnore
    public Optional<String> getForwarderPayCourierRateSheetId() {
        if (forwarderPayCourierRateSheetId == null) {
            return Optional.empty();
        }
        return forwarderPayCourierRateSheetId;
    }

    @JsonIgnore
    public Optional<String> getForwarderPayCourierLineItemGroupId() {
        if (forwarderPayCourierLineItemGroupId == null) {
            return Optional.empty();
        }
        return forwarderPayCourierLineItemGroupId;
    }

    @JsonIgnore
    public Optional<String> getShipperPayCourierRateSheetId() {
        if (shipperPayCourierRateSheetId == null) {
            return Optional.empty();
        }
        return shipperPayCourierRateSheetId;
    }

    @JsonIgnore
    public Optional<String> getShipperPayCourierLineItemGroupId() {
        if (shipperPayCourierLineItemGroupId == null) {
            return Optional.empty();
        }
        return shipperPayCourierLineItemGroupId;
    }

    @JsonIgnore
    public Optional<String> getCourierPayDriverRateSheetId() {
        if (courierPayDriverRateSheetId == null) {
            return Optional.empty();
        }
        return courierPayDriverRateSheetId;
    }

    @JsonIgnore
    public Optional<String> getCourierPayDriverLineItemGroupId() {
        if (courierPayDriverLineItemGroupId == null) {
            return Optional.empty();
        }
        return courierPayDriverLineItemGroupId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return courierOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("driver_id")
    private Optional<String> _getDriverId() {
        return driverId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("in_progress_at_timestamp")
    private Optional<OffsetDateTime> _getInProgressAtTimestamp() {
        return inProgressAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return completedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return skippedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("tasks_mileage")
    private Optional<Double> _getTasksMileage() {
        return tasksMileage;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("flight_number")
    private Optional<String> _getFlightNumber() {
        return flightNumber;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_pay_forwarder_rate_sheet_id")
    private Optional<String> _getShipperPayForwarderRateSheetId() {
        return shipperPayForwarderRateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_pay_forwarder_line_item_group_id")
    private Optional<String> _getShipperPayForwarderLineItemGroupId() {
        return shipperPayForwarderLineItemGroupId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_pay_courier_rate_sheet_id")
    private Optional<String> _getForwarderPayCourierRateSheetId() {
        return forwarderPayCourierRateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_pay_courier_line_item_group_id")
    private Optional<String> _getForwarderPayCourierLineItemGroupId() {
        return forwarderPayCourierLineItemGroupId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_pay_courier_rate_sheet_id")
    private Optional<String> _getShipperPayCourierRateSheetId() {
        return shipperPayCourierRateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_pay_courier_line_item_group_id")
    private Optional<String> _getShipperPayCourierLineItemGroupId() {
        return shipperPayCourierLineItemGroupId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_pay_driver_rate_sheet_id")
    private Optional<String> _getCourierPayDriverRateSheetId() {
        return courierPayDriverRateSheetId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_pay_driver_line_item_group_id")
    private Optional<String> _getCourierPayDriverLineItemGroupId() {
        return courierPayDriverLineItemGroupId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroup1 && equalTo((TaskGroup1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroup1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && taskIds.equals(other.taskIds)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && courierOrgId.equals(other.courierOrgId)
                && driverId.equals(other.driverId)
                && serviceType.equals(other.serviceType)
                && taskGroupS3ObjectMetadataIds.equals(other.taskGroupS3ObjectMetadataIds)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && inProgressAtTimestamp.equals(other.inProgressAtTimestamp)
                && completedAtTimestamp.equals(other.completedAtTimestamp)
                && skippedAtTimestamp.equals(other.skippedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp)
                && orderCancelled.equals(other.orderCancelled)
                && taskGroupType.equals(other.taskGroupType)
                && tasksMileage.equals(other.tasksMileage)
                && flightNumber.equals(other.flightNumber)
                && faFlightIds.equals(other.faFlightIds)
                && messages.equals(other.messages)
                && shipperPayForwarderRateSheetId.equals(other.shipperPayForwarderRateSheetId)
                && shipperPayForwarderLineItemGroupId.equals(other.shipperPayForwarderLineItemGroupId)
                && forwarderPayCourierRateSheetId.equals(other.forwarderPayCourierRateSheetId)
                && forwarderPayCourierLineItemGroupId.equals(other.forwarderPayCourierLineItemGroupId)
                && shipperPayCourierRateSheetId.equals(other.shipperPayCourierRateSheetId)
                && shipperPayCourierLineItemGroupId.equals(other.shipperPayCourierLineItemGroupId)
                && courierPayDriverRateSheetId.equals(other.courierPayDriverRateSheetId)
                && courierPayDriverLineItemGroupId.equals(other.courierPayDriverLineItemGroupId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.orderId,
                this.orderShortId,
                this.taskIds,
                this.createdByOrgId,
                this.createdByUserId,
                this.courierOrgId,
                this.driverId,
                this.serviceType,
                this.taskGroupS3ObjectMetadataIds,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.inProgressAtTimestamp,
                this.completedAtTimestamp,
                this.skippedAtTimestamp,
                this.exceptionAtTimestamp,
                this.orderCancelled,
                this.taskGroupType,
                this.tasksMileage,
                this.flightNumber,
                this.faFlightIds,
                this.messages,
                this.shipperPayForwarderRateSheetId,
                this.shipperPayForwarderLineItemGroupId,
                this.forwarderPayCourierRateSheetId,
                this.forwarderPayCourierLineItemGroupId,
                this.shipperPayCourierRateSheetId,
                this.shipperPayCourierLineItemGroupId,
                this.courierPayDriverRateSheetId,
                this.courierPayDriverLineItemGroupId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(TaskGroup1 other);
    }

    public interface IdStage {
        OrderIdStage id(@NotNull String id);
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);
    }

    public interface OrderShortIdStage {
        CreatedByOrgIdStage orderShortId(@NotNull String orderShortId);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface TaskGroupTypeStage {
        _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType);
    }

    public interface _FinalStage {
        TaskGroup1 build();

        _FinalStage taskIds(Optional<List<String>> taskIds);

        _FinalStage taskIds(List<String> taskIds);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage courierOrgId(Optional<String> courierOrgId);

        _FinalStage courierOrgId(String courierOrgId);

        _FinalStage courierOrgId(Nullable<String> courierOrgId);

        _FinalStage driverId(Optional<String> driverId);

        _FinalStage driverId(String driverId);

        _FinalStage driverId(Nullable<String> driverId);

        _FinalStage serviceType(Optional<ServiceTypeEnum1> serviceType);

        _FinalStage serviceType(ServiceTypeEnum1 serviceType);

        _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> taskGroupS3ObjectMetadataIds);

        _FinalStage taskGroupS3ObjectMetadataIds(List<String> taskGroupS3ObjectMetadataIds);

        _FinalStage status(Optional<TaskGroupStatusEnum1> status);

        _FinalStage status(TaskGroupStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp);

        _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp);

        _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp);

        _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage tasksMileage(Optional<Double> tasksMileage);

        _FinalStage tasksMileage(Double tasksMileage);

        _FinalStage tasksMileage(Nullable<Double> tasksMileage);

        _FinalStage flightNumber(Optional<String> flightNumber);

        _FinalStage flightNumber(String flightNumber);

        _FinalStage flightNumber(Nullable<String> flightNumber);

        _FinalStage faFlightIds(Optional<List<String>> faFlightIds);

        _FinalStage faFlightIds(List<String> faFlightIds);

        _FinalStage messages(Optional<List<TaskGroupMessage1>> messages);

        _FinalStage messages(List<TaskGroupMessage1> messages);

        _FinalStage shipperPayForwarderRateSheetId(Optional<String> shipperPayForwarderRateSheetId);

        _FinalStage shipperPayForwarderRateSheetId(String shipperPayForwarderRateSheetId);

        _FinalStage shipperPayForwarderRateSheetId(Nullable<String> shipperPayForwarderRateSheetId);

        _FinalStage shipperPayForwarderLineItemGroupId(Optional<String> shipperPayForwarderLineItemGroupId);

        _FinalStage shipperPayForwarderLineItemGroupId(String shipperPayForwarderLineItemGroupId);

        _FinalStage shipperPayForwarderLineItemGroupId(Nullable<String> shipperPayForwarderLineItemGroupId);

        _FinalStage forwarderPayCourierRateSheetId(Optional<String> forwarderPayCourierRateSheetId);

        _FinalStage forwarderPayCourierRateSheetId(String forwarderPayCourierRateSheetId);

        _FinalStage forwarderPayCourierRateSheetId(Nullable<String> forwarderPayCourierRateSheetId);

        _FinalStage forwarderPayCourierLineItemGroupId(Optional<String> forwarderPayCourierLineItemGroupId);

        _FinalStage forwarderPayCourierLineItemGroupId(String forwarderPayCourierLineItemGroupId);

        _FinalStage forwarderPayCourierLineItemGroupId(Nullable<String> forwarderPayCourierLineItemGroupId);

        _FinalStage shipperPayCourierRateSheetId(Optional<String> shipperPayCourierRateSheetId);

        _FinalStage shipperPayCourierRateSheetId(String shipperPayCourierRateSheetId);

        _FinalStage shipperPayCourierRateSheetId(Nullable<String> shipperPayCourierRateSheetId);

        _FinalStage shipperPayCourierLineItemGroupId(Optional<String> shipperPayCourierLineItemGroupId);

        _FinalStage shipperPayCourierLineItemGroupId(String shipperPayCourierLineItemGroupId);

        _FinalStage shipperPayCourierLineItemGroupId(Nullable<String> shipperPayCourierLineItemGroupId);

        _FinalStage courierPayDriverRateSheetId(Optional<String> courierPayDriverRateSheetId);

        _FinalStage courierPayDriverRateSheetId(String courierPayDriverRateSheetId);

        _FinalStage courierPayDriverRateSheetId(Nullable<String> courierPayDriverRateSheetId);

        _FinalStage courierPayDriverLineItemGroupId(Optional<String> courierPayDriverLineItemGroupId);

        _FinalStage courierPayDriverLineItemGroupId(String courierPayDriverLineItemGroupId);

        _FinalStage courierPayDriverLineItemGroupId(Nullable<String> courierPayDriverLineItemGroupId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    OrderIdStage,
                    OrderShortIdStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    TaskGroupTypeStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String orderId;

        private String orderShortId;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private TaskGroupTypeEnum1 taskGroupType;

        private Optional<String> courierPayDriverLineItemGroupId = Optional.empty();

        private Optional<String> courierPayDriverRateSheetId = Optional.empty();

        private Optional<String> shipperPayCourierLineItemGroupId = Optional.empty();

        private Optional<String> shipperPayCourierRateSheetId = Optional.empty();

        private Optional<String> forwarderPayCourierLineItemGroupId = Optional.empty();

        private Optional<String> forwarderPayCourierRateSheetId = Optional.empty();

        private Optional<String> shipperPayForwarderLineItemGroupId = Optional.empty();

        private Optional<String> shipperPayForwarderRateSheetId = Optional.empty();

        private Optional<List<TaskGroupMessage1>> messages = Optional.empty();

        private Optional<List<String>> faFlightIds = Optional.empty();

        private Optional<String> flightNumber = Optional.empty();

        private Optional<Double> tasksMileage = Optional.empty();

        private Optional<Boolean> orderCancelled = Optional.empty();

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> inProgressAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<TaskGroupStatusEnum1> status = Optional.empty();

        private Optional<List<String>> taskGroupS3ObjectMetadataIds = Optional.empty();

        private Optional<ServiceTypeEnum1> serviceType = Optional.empty();

        private Optional<String> driverId = Optional.empty();

        private Optional<String> courierOrgId = Optional.empty();

        private Optional<List<String>> taskIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroup1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            taskIds(other.getTaskIds());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            courierOrgId(other.getCourierOrgId());
            driverId(other.getDriverId());
            serviceType(other.getServiceType());
            taskGroupS3ObjectMetadataIds(other.getTaskGroupS3ObjectMetadataIds());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            inProgressAtTimestamp(other.getInProgressAtTimestamp());
            completedAtTimestamp(other.getCompletedAtTimestamp());
            skippedAtTimestamp(other.getSkippedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            orderCancelled(other.getOrderCancelled());
            taskGroupType(other.getTaskGroupType());
            tasksMileage(other.getTasksMileage());
            flightNumber(other.getFlightNumber());
            faFlightIds(other.getFaFlightIds());
            messages(other.getMessages());
            shipperPayForwarderRateSheetId(other.getShipperPayForwarderRateSheetId());
            shipperPayForwarderLineItemGroupId(other.getShipperPayForwarderLineItemGroupId());
            forwarderPayCourierRateSheetId(other.getForwarderPayCourierRateSheetId());
            forwarderPayCourierLineItemGroupId(other.getForwarderPayCourierLineItemGroupId());
            shipperPayCourierRateSheetId(other.getShipperPayCourierRateSheetId());
            shipperPayCourierLineItemGroupId(other.getShipperPayCourierLineItemGroupId());
            courierPayDriverRateSheetId(other.getCourierPayDriverRateSheetId());
            courierPayDriverLineItemGroupId(other.getCourierPayDriverLineItemGroupId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public CreatedByOrgIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public TaskGroupTypeStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_type")
        public _FinalStage taskGroupType(@NotNull TaskGroupTypeEnum1 taskGroupType) {
            this.taskGroupType = Objects.requireNonNull(taskGroupType, "taskGroupType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverLineItemGroupId(Nullable<String> courierPayDriverLineItemGroupId) {
            if (courierPayDriverLineItemGroupId.isNull()) {
                this.courierPayDriverLineItemGroupId = null;
            } else if (courierPayDriverLineItemGroupId.isEmpty()) {
                this.courierPayDriverLineItemGroupId = Optional.empty();
            } else {
                this.courierPayDriverLineItemGroupId = Optional.of(courierPayDriverLineItemGroupId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverLineItemGroupId(String courierPayDriverLineItemGroupId) {
            this.courierPayDriverLineItemGroupId = Optional.ofNullable(courierPayDriverLineItemGroupId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_line_item_group_id", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverLineItemGroupId(Optional<String> courierPayDriverLineItemGroupId) {
            this.courierPayDriverLineItemGroupId = courierPayDriverLineItemGroupId;
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverRateSheetId(Nullable<String> courierPayDriverRateSheetId) {
            if (courierPayDriverRateSheetId.isNull()) {
                this.courierPayDriverRateSheetId = null;
            } else if (courierPayDriverRateSheetId.isEmpty()) {
                this.courierPayDriverRateSheetId = Optional.empty();
            } else {
                this.courierPayDriverRateSheetId = Optional.of(courierPayDriverRateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage courierPayDriverRateSheetId(String courierPayDriverRateSheetId) {
            this.courierPayDriverRateSheetId = Optional.ofNullable(courierPayDriverRateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverRateSheetId(Optional<String> courierPayDriverRateSheetId) {
            this.courierPayDriverRateSheetId = courierPayDriverRateSheetId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayCourierLineItemGroupId(Nullable<String> shipperPayCourierLineItemGroupId) {
            if (shipperPayCourierLineItemGroupId.isNull()) {
                this.shipperPayCourierLineItemGroupId = null;
            } else if (shipperPayCourierLineItemGroupId.isEmpty()) {
                this.shipperPayCourierLineItemGroupId = Optional.empty();
            } else {
                this.shipperPayCourierLineItemGroupId = Optional.of(shipperPayCourierLineItemGroupId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayCourierLineItemGroupId(String shipperPayCourierLineItemGroupId) {
            this.shipperPayCourierLineItemGroupId = Optional.ofNullable(shipperPayCourierLineItemGroupId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_pay_courier_line_item_group_id", nulls = Nulls.SKIP)
        public _FinalStage shipperPayCourierLineItemGroupId(Optional<String> shipperPayCourierLineItemGroupId) {
            this.shipperPayCourierLineItemGroupId = shipperPayCourierLineItemGroupId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayCourierRateSheetId(Nullable<String> shipperPayCourierRateSheetId) {
            if (shipperPayCourierRateSheetId.isNull()) {
                this.shipperPayCourierRateSheetId = null;
            } else if (shipperPayCourierRateSheetId.isEmpty()) {
                this.shipperPayCourierRateSheetId = Optional.empty();
            } else {
                this.shipperPayCourierRateSheetId = Optional.of(shipperPayCourierRateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayCourierRateSheetId(String shipperPayCourierRateSheetId) {
            this.shipperPayCourierRateSheetId = Optional.ofNullable(shipperPayCourierRateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_pay_courier_rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage shipperPayCourierRateSheetId(Optional<String> shipperPayCourierRateSheetId) {
            this.shipperPayCourierRateSheetId = shipperPayCourierRateSheetId;
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderPayCourierLineItemGroupId(Nullable<String> forwarderPayCourierLineItemGroupId) {
            if (forwarderPayCourierLineItemGroupId.isNull()) {
                this.forwarderPayCourierLineItemGroupId = null;
            } else if (forwarderPayCourierLineItemGroupId.isEmpty()) {
                this.forwarderPayCourierLineItemGroupId = Optional.empty();
            } else {
                this.forwarderPayCourierLineItemGroupId = Optional.of(forwarderPayCourierLineItemGroupId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderPayCourierLineItemGroupId(String forwarderPayCourierLineItemGroupId) {
            this.forwarderPayCourierLineItemGroupId = Optional.ofNullable(forwarderPayCourierLineItemGroupId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_pay_courier_line_item_group_id", nulls = Nulls.SKIP)
        public _FinalStage forwarderPayCourierLineItemGroupId(Optional<String> forwarderPayCourierLineItemGroupId) {
            this.forwarderPayCourierLineItemGroupId = forwarderPayCourierLineItemGroupId;
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderPayCourierRateSheetId(Nullable<String> forwarderPayCourierRateSheetId) {
            if (forwarderPayCourierRateSheetId.isNull()) {
                this.forwarderPayCourierRateSheetId = null;
            } else if (forwarderPayCourierRateSheetId.isEmpty()) {
                this.forwarderPayCourierRateSheetId = Optional.empty();
            } else {
                this.forwarderPayCourierRateSheetId = Optional.of(forwarderPayCourierRateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderPayCourierRateSheetId(String forwarderPayCourierRateSheetId) {
            this.forwarderPayCourierRateSheetId = Optional.ofNullable(forwarderPayCourierRateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_pay_courier_rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage forwarderPayCourierRateSheetId(Optional<String> forwarderPayCourierRateSheetId) {
            this.forwarderPayCourierRateSheetId = forwarderPayCourierRateSheetId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayForwarderLineItemGroupId(Nullable<String> shipperPayForwarderLineItemGroupId) {
            if (shipperPayForwarderLineItemGroupId.isNull()) {
                this.shipperPayForwarderLineItemGroupId = null;
            } else if (shipperPayForwarderLineItemGroupId.isEmpty()) {
                this.shipperPayForwarderLineItemGroupId = Optional.empty();
            } else {
                this.shipperPayForwarderLineItemGroupId = Optional.of(shipperPayForwarderLineItemGroupId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayForwarderLineItemGroupId(String shipperPayForwarderLineItemGroupId) {
            this.shipperPayForwarderLineItemGroupId = Optional.ofNullable(shipperPayForwarderLineItemGroupId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_pay_forwarder_line_item_group_id", nulls = Nulls.SKIP)
        public _FinalStage shipperPayForwarderLineItemGroupId(Optional<String> shipperPayForwarderLineItemGroupId) {
            this.shipperPayForwarderLineItemGroupId = shipperPayForwarderLineItemGroupId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayForwarderRateSheetId(Nullable<String> shipperPayForwarderRateSheetId) {
            if (shipperPayForwarderRateSheetId.isNull()) {
                this.shipperPayForwarderRateSheetId = null;
            } else if (shipperPayForwarderRateSheetId.isEmpty()) {
                this.shipperPayForwarderRateSheetId = Optional.empty();
            } else {
                this.shipperPayForwarderRateSheetId = Optional.of(shipperPayForwarderRateSheetId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperPayForwarderRateSheetId(String shipperPayForwarderRateSheetId) {
            this.shipperPayForwarderRateSheetId = Optional.ofNullable(shipperPayForwarderRateSheetId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_pay_forwarder_rate_sheet_id", nulls = Nulls.SKIP)
        public _FinalStage shipperPayForwarderRateSheetId(Optional<String> shipperPayForwarderRateSheetId) {
            this.shipperPayForwarderRateSheetId = shipperPayForwarderRateSheetId;
            return this;
        }

        @java.lang.Override
        public _FinalStage messages(List<TaskGroupMessage1> messages) {
            this.messages = Optional.ofNullable(messages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "messages", nulls = Nulls.SKIP)
        public _FinalStage messages(Optional<List<TaskGroupMessage1>> messages) {
            this.messages = messages;
            return this;
        }

        @java.lang.Override
        public _FinalStage faFlightIds(List<String> faFlightIds) {
            this.faFlightIds = Optional.ofNullable(faFlightIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "fa_flight_ids", nulls = Nulls.SKIP)
        public _FinalStage faFlightIds(Optional<List<String>> faFlightIds) {
            this.faFlightIds = faFlightIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage flightNumber(Nullable<String> flightNumber) {
            if (flightNumber.isNull()) {
                this.flightNumber = null;
            } else if (flightNumber.isEmpty()) {
                this.flightNumber = Optional.empty();
            } else {
                this.flightNumber = Optional.of(flightNumber.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flight_number", nulls = Nulls.SKIP)
        public _FinalStage flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        @java.lang.Override
        public _FinalStage tasksMileage(Nullable<Double> tasksMileage) {
            if (tasksMileage.isNull()) {
                this.tasksMileage = null;
            } else if (tasksMileage.isEmpty()) {
                this.tasksMileage = Optional.empty();
            } else {
                this.tasksMileage = Optional.of(tasksMileage.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage tasksMileage(Double tasksMileage) {
            this.tasksMileage = Optional.ofNullable(tasksMileage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tasks_mileage", nulls = Nulls.SKIP)
        public _FinalStage tasksMileage(Optional<Double> tasksMileage) {
            this.tasksMileage = tasksMileage;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            if (skippedAtTimestamp.isNull()) {
                this.skippedAtTimestamp = null;
            } else if (skippedAtTimestamp.isEmpty()) {
                this.skippedAtTimestamp = Optional.empty();
            } else {
                this.skippedAtTimestamp = Optional.of(skippedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "skipped_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            if (completedAtTimestamp.isNull()) {
                this.completedAtTimestamp = null;
            } else if (completedAtTimestamp.isEmpty()) {
                this.completedAtTimestamp = Optional.empty();
            } else {
                this.completedAtTimestamp = Optional.of(completedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp) {
            if (inProgressAtTimestamp.isNull()) {
                this.inProgressAtTimestamp = null;
            } else if (inProgressAtTimestamp.isEmpty()) {
                this.inProgressAtTimestamp = Optional.empty();
            } else {
                this.inProgressAtTimestamp = Optional.of(inProgressAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp) {
            this.inProgressAtTimestamp = Optional.ofNullable(inProgressAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "in_progress_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(TaskGroupStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<TaskGroupStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupS3ObjectMetadataIds(List<String> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = Optional.ofNullable(taskGroupS3ObjectMetadataIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_s3_object_metadata_ids", nulls = Nulls.SKIP)
        public _FinalStage taskGroupS3ObjectMetadataIds(Optional<List<String>> taskGroupS3ObjectMetadataIds) {
            this.taskGroupS3ObjectMetadataIds = taskGroupS3ObjectMetadataIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage serviceType(ServiceTypeEnum1 serviceType) {
            this.serviceType = Optional.ofNullable(serviceType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "service_type", nulls = Nulls.SKIP)
        public _FinalStage serviceType(Optional<ServiceTypeEnum1> serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @java.lang.Override
        public _FinalStage driverId(Nullable<String> driverId) {
            if (driverId.isNull()) {
                this.driverId = null;
            } else if (driverId.isEmpty()) {
                this.driverId = Optional.empty();
            } else {
                this.driverId = Optional.of(driverId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage driverId(String driverId) {
            this.driverId = Optional.ofNullable(driverId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "driver_id", nulls = Nulls.SKIP)
        public _FinalStage driverId(Optional<String> driverId) {
            this.driverId = driverId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(Nullable<String> courierOrgId) {
            if (courierOrgId.isNull()) {
                this.courierOrgId = null;
            } else if (courierOrgId.isEmpty()) {
                this.courierOrgId = Optional.empty();
            } else {
                this.courierOrgId = Optional.of(courierOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "courier_org_id", nulls = Nulls.SKIP)
        public _FinalStage courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskIds(List<String> taskIds) {
            this.taskIds = Optional.ofNullable(taskIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_ids", nulls = Nulls.SKIP)
        public _FinalStage taskIds(Optional<List<String>> taskIds) {
            this.taskIds = taskIds;
            return this;
        }

        @java.lang.Override
        public TaskGroup1 build() {
            return new TaskGroup1(
                    schemaVersion,
                    id,
                    orderId,
                    orderShortId,
                    taskIds,
                    createdByOrgId,
                    createdByUserId,
                    courierOrgId,
                    driverId,
                    serviceType,
                    taskGroupS3ObjectMetadataIds,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    inProgressAtTimestamp,
                    completedAtTimestamp,
                    skippedAtTimestamp,
                    exceptionAtTimestamp,
                    orderCancelled,
                    taskGroupType,
                    tasksMileage,
                    flightNumber,
                    faFlightIds,
                    messages,
                    shipperPayForwarderRateSheetId,
                    shipperPayForwarderLineItemGroupId,
                    forwarderPayCourierRateSheetId,
                    forwarderPayCourierLineItemGroupId,
                    shipperPayCourierRateSheetId,
                    shipperPayCourierLineItemGroupId,
                    courierPayDriverRateSheetId,
                    courierPayDriverLineItemGroupId,
                    additionalProperties);
        }
    }
}
