/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroupS3ObjectMetadata1.Builder.class)
public final class TaskGroupS3ObjectMetadata1 {
    private final int schemaVersion;

    private final String id;

    private final String taskGroupId;

    private final OffsetDateTime uploadedAtTimestamp;

    private final String uploadedByUserId;

    private final String uploadedByOrgId;

    private final Optional<String> s3KeyPrefix;

    private final Optional<String> blurhash;

    private final Map<String, Object> additionalProperties;

    private TaskGroupS3ObjectMetadata1(
            int schemaVersion,
            String id,
            String taskGroupId,
            OffsetDateTime uploadedAtTimestamp,
            String uploadedByUserId,
            String uploadedByOrgId,
            Optional<String> s3KeyPrefix,
            Optional<String> blurhash,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.taskGroupId = taskGroupId;
        this.uploadedAtTimestamp = uploadedAtTimestamp;
        this.uploadedByUserId = uploadedByUserId;
        this.uploadedByOrgId = uploadedByOrgId;
        this.s3KeyPrefix = s3KeyPrefix;
        this.blurhash = blurhash;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("uploaded_at_timestamp")
    public OffsetDateTime getUploadedAtTimestamp() {
        return uploadedAtTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("uploaded_by_user_id")
    public String getUploadedByUserId() {
        return uploadedByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("uploaded_by_org_id")
    public String getUploadedByOrgId() {
        return uploadedByOrgId;
    }

    @JsonProperty("s3_key_prefix")
    public Optional<String> getS3KeyPrefix() {
        return s3KeyPrefix;
    }

    @JsonIgnore
    public Optional<String> getBlurhash() {
        if (blurhash == null) {
            return Optional.empty();
        }
        return blurhash;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("blurhash")
    private Optional<String> _getBlurhash() {
        return blurhash;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroupS3ObjectMetadata1 && equalTo((TaskGroupS3ObjectMetadata1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupS3ObjectMetadata1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && taskGroupId.equals(other.taskGroupId)
                && uploadedAtTimestamp.equals(other.uploadedAtTimestamp)
                && uploadedByUserId.equals(other.uploadedByUserId)
                && uploadedByOrgId.equals(other.uploadedByOrgId)
                && s3KeyPrefix.equals(other.s3KeyPrefix)
                && blurhash.equals(other.blurhash);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.taskGroupId,
                this.uploadedAtTimestamp,
                this.uploadedByUserId,
                this.uploadedByOrgId,
                this.s3KeyPrefix,
                this.blurhash);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(TaskGroupS3ObjectMetadata1 other);
    }

    public interface IdStage {
        TaskGroupIdStage id(@NotNull String id);
    }

    public interface TaskGroupIdStage {
        UploadedAtTimestampStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface UploadedAtTimestampStage {
        UploadedByUserIdStage uploadedAtTimestamp(@NotNull OffsetDateTime uploadedAtTimestamp);
    }

    public interface UploadedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        UploadedByOrgIdStage uploadedByUserId(@NotNull String uploadedByUserId);
    }

    public interface UploadedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage uploadedByOrgId(@NotNull String uploadedByOrgId);
    }

    public interface _FinalStage {
        TaskGroupS3ObjectMetadata1 build();

        _FinalStage s3KeyPrefix(Optional<String> s3KeyPrefix);

        _FinalStage s3KeyPrefix(String s3KeyPrefix);

        _FinalStage blurhash(Optional<String> blurhash);

        _FinalStage blurhash(String blurhash);

        _FinalStage blurhash(Nullable<String> blurhash);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    TaskGroupIdStage,
                    UploadedAtTimestampStage,
                    UploadedByUserIdStage,
                    UploadedByOrgIdStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String taskGroupId;

        private OffsetDateTime uploadedAtTimestamp;

        private String uploadedByUserId;

        private String uploadedByOrgId;

        private Optional<String> blurhash = Optional.empty();

        private Optional<String> s3KeyPrefix = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroupS3ObjectMetadata1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            taskGroupId(other.getTaskGroupId());
            uploadedAtTimestamp(other.getUploadedAtTimestamp());
            uploadedByUserId(other.getUploadedByUserId());
            uploadedByOrgId(other.getUploadedByOrgId());
            s3KeyPrefix(other.getS3KeyPrefix());
            blurhash(other.getBlurhash());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public TaskGroupIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public UploadedAtTimestampStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("uploaded_at_timestamp")
        public UploadedByUserIdStage uploadedAtTimestamp(@NotNull OffsetDateTime uploadedAtTimestamp) {
            this.uploadedAtTimestamp =
                    Objects.requireNonNull(uploadedAtTimestamp, "uploadedAtTimestamp must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("uploaded_by_user_id")
        public UploadedByOrgIdStage uploadedByUserId(@NotNull String uploadedByUserId) {
            this.uploadedByUserId = Objects.requireNonNull(uploadedByUserId, "uploadedByUserId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("uploaded_by_org_id")
        public _FinalStage uploadedByOrgId(@NotNull String uploadedByOrgId) {
            this.uploadedByOrgId = Objects.requireNonNull(uploadedByOrgId, "uploadedByOrgId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage blurhash(Nullable<String> blurhash) {
            if (blurhash.isNull()) {
                this.blurhash = null;
            } else if (blurhash.isEmpty()) {
                this.blurhash = Optional.empty();
            } else {
                this.blurhash = Optional.of(blurhash.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage blurhash(String blurhash) {
            this.blurhash = Optional.ofNullable(blurhash);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "blurhash", nulls = Nulls.SKIP)
        public _FinalStage blurhash(Optional<String> blurhash) {
            this.blurhash = blurhash;
            return this;
        }

        @java.lang.Override
        public _FinalStage s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = Optional.ofNullable(s3KeyPrefix);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "s3_key_prefix", nulls = Nulls.SKIP)
        public _FinalStage s3KeyPrefix(Optional<String> s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @java.lang.Override
        public TaskGroupS3ObjectMetadata1 build() {
            return new TaskGroupS3ObjectMetadata1(
                    schemaVersion,
                    id,
                    taskGroupId,
                    uploadedAtTimestamp,
                    uploadedByUserId,
                    uploadedByOrgId,
                    s3KeyPrefix,
                    blurhash,
                    additionalProperties);
        }
    }
}
