/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api;

import com.chrt.api.ChrtApiClient;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class ChrtApiClientBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private String token = null;
    private Environment environment = Environment.LOCAL;
    private OkHttpClient httpClient;

    public ChrtApiClientBuilder token(String token) {
        this.token = token;
        return this;
    }

    public ChrtApiClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public ChrtApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public ChrtApiClientBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public ChrtApiClientBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public ChrtApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ChrtApiClientBuilder addHeader(String name, String value) {
        this.customHeaders.put(name, value);
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setAuthentication(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setAuthentication(ClientOptions.Builder builder) {
        if (this.token != null) {
            builder.addHeader("Authorization", "Bearer " + this.token);
        }
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public ChrtApiClient build() {
        this.validateConfiguration();
        return new ChrtApiClient(this.buildClientOptions());
    }
}

