/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.lineitemgroups.AsyncLineItemGroupsClient;
import com.chrt.api.resources.billing.ratesheets.AsyncRateSheetsClient;
import com.chrt.api.resources.billing.statements.AsyncStatementsClient;
import com.chrt.api.resources.billing.stripeconnect.AsyncStripeConnectClient;
import java.util.function.Supplier;

public class AsyncBillingClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<AsyncLineItemGroupsClient> lineItemGroupsClient;
    protected final Supplier<AsyncRateSheetsClient> rateSheetsClient;
    protected final Supplier<AsyncStatementsClient> statementsClient;
    protected final Supplier<AsyncStripeConnectClient> stripeConnectClient;

    public AsyncBillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.lineItemGroupsClient = Suppliers.memoize(() -> new AsyncLineItemGroupsClient(clientOptions));
        this.rateSheetsClient = Suppliers.memoize(() -> new AsyncRateSheetsClient(clientOptions));
        this.statementsClient = Suppliers.memoize(() -> new AsyncStatementsClient(clientOptions));
        this.stripeConnectClient = Suppliers.memoize(() -> new AsyncStripeConnectClient(clientOptions));
    }

    public AsyncLineItemGroupsClient lineItemGroups() {
        return this.lineItemGroupsClient.get();
    }

    public AsyncRateSheetsClient rateSheets() {
        return this.rateSheetsClient.get();
    }

    public AsyncStatementsClient statements() {
        return this.statementsClient.get();
    }

    public AsyncStripeConnectClient stripeConnect() {
        return this.stripeConnectClient.get();
    }
}

