/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.billing.lineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.billing.lineitemgroups.AsyncRawLineItemGroupsClient;
import com.chrt.api.resources.billing.lineitemgroups.adhoc.AsyncAdHocClient;
import com.chrt.api.resources.billing.lineitemgroups.messages.AsyncMessagesClient;
import com.chrt.api.resources.billing.lineitemgroups.requests.AdjustLineItemReq;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsAssociateWithStatementV1Request;
import com.chrt.api.resources.billing.lineitemgroups.requests.LineItemGroupsListForCourierOrgV1Request;
import com.chrt.api.resources.billing.lineitemgroups.s3objects.AsyncS3ObjectsClient;
import com.chrt.api.types.LineItemGroup1;
import com.chrt.api.types.LineItemGroupListRes;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncLineItemGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawLineItemGroupsClient rawClient;
    protected final Supplier<AsyncAdHocClient> adHocClient;
    protected final Supplier<AsyncMessagesClient> messagesClient;
    protected final Supplier<AsyncS3ObjectsClient> s3ObjectsClient;

    public AsyncLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawLineItemGroupsClient(clientOptions);
        this.adHocClient = Suppliers.memoize(() -> new AsyncAdHocClient(clientOptions));
        this.messagesClient = Suppliers.memoize(() -> new AsyncMessagesClient(clientOptions));
        this.s3ObjectsClient = Suppliers.memoize(() -> new AsyncS3ObjectsClient(clientOptions));
    }

    public AsyncRawLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<LineItemGroup1> getV1(String lineItemGroupId) {
        return this.rawClient.getV1(lineItemGroupId).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> getV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.getV1(lineItemGroupId, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1() {
        return this.rawClient.listForCourierOrgV1().thenApply(response -> (LineItemGroupListRes)response.body());
    }

    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request) {
        return this.rawClient.listForCourierOrgV1(request).thenApply(response -> (LineItemGroupListRes)response.body());
    }

    public CompletableFuture<LineItemGroupListRes> listForCourierOrgV1(LineItemGroupsListForCourierOrgV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listForCourierOrgV1(request, requestOptions).thenApply(response -> (LineItemGroupListRes)response.body());
    }

    public CompletableFuture<LineItemGroup1> finalizeV1(String lineItemGroupId) {
        return this.rawClient.finalizeV1(lineItemGroupId).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> finalizeV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.finalizeV1(lineItemGroupId, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> calculateLineItemsV1(String lineItemGroupId) {
        return this.rawClient.calculateLineItemsV1(lineItemGroupId).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> calculateLineItemsV1(String lineItemGroupId, RequestOptions requestOptions) {
        return this.rawClient.calculateLineItemsV1(lineItemGroupId, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request) {
        return this.rawClient.associateWithStatementV1(lineItemGroupId, request).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> associateWithStatementV1(String lineItemGroupId, LineItemGroupsAssociateWithStatementV1Request request, RequestOptions requestOptions) {
        return this.rawClient.associateWithStatementV1(lineItemGroupId, request, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request) {
        return this.rawClient.adjustLineItemV1(lineItemGroupId, request).thenApply(response -> (LineItemGroup1)response.body());
    }

    public CompletableFuture<LineItemGroup1> adjustLineItemV1(String lineItemGroupId, AdjustLineItemReq request, RequestOptions requestOptions) {
        return this.rawClient.adjustLineItemV1(lineItemGroupId, request, requestOptions).thenApply(response -> (LineItemGroup1)response.body());
    }

    public AsyncAdHocClient adHoc() {
        return this.adHocClient.get();
    }

    public AsyncMessagesClient messages() {
        return this.messagesClient.get();
    }

    public AsyncS3ObjectsClient s3Objects() {
        return this.s3ObjectsClient.get();
    }
}

